# -*- coding: utf-8 -*-
module ProjectCollaboration

  # このモジュールを include するクラスではインスタンスが以下のメッセージに respond_to である:
  # * input_type
  # * input_parameter
  module PjInputOptionHelper

    # PjInputOption 参照を行うかどうかを判定する。
    def pj_input_option?
      return false unless %w|select radio|.include?(input_type)
      return false unless input_parameter =~ /\Apj_input_option\(\s*(\S+)\s*,\s*(\S+)\s*\)\z/
      @pj_input_option_category ||= $1
      @pj_input_option_column_name ||= $2
      return true
    end

    # 指定されたカテゴリを返す。
    # エラーの場合は nil を返す。
    def pj_input_option_category
      return nil unless pj_input_option?
      @pj_input_option_category
    end

    # 指定されたカラム名を返す。
    # エラーの場合は nil を返す。
    def pj_input_option_column_name
      return nil unless pj_input_option?
      @pj_input_option_column_name
    end

    # 指定されたカラム名にしたがって it から(できれば)プロジェクトIDを返す。
    # さもなくば nil を返す。
    def pj_input_option_project_id(it)
      return nil unless pj_input_option?
      @pj_input_option_column_name.split('.').inject(it) do |a, n|
        return nil unless a.respond_to?(n)
        a.__send__(n)
      end
    end

  end
end
