# -*- coding: utf-8 -*-
module NarrowingCondition
  class ProjectSegment
    include GetText

    bindtextdomain("database")

    attr_accessor :narrowing

    def initialize(narrowing)
      @narrowing = narrowing
    end

    # シンボルの配列を返す。
    def value_keys
      [:project_id, :project_segment_id]
    end

    def text(values)
      project_segment_id = values[:project_segment_id]
      return nil if project_segment_id.blank?
      ::ProjectSegment.find(project_segment_id).to_text
    rescue ActiveRecord::RecordNotFound
      nil
    end

    def condition(table_name, column_name)
      project_segment_id = Narrowing.current(narrowing, :project_segment_id)
      project_segment_id.blank? ? nil : "#{table_name}.#{column_name} = #{::ProjectSegment.quote_value(project_segment_id)}"
    end

  end
end
