# 設備予約登録画面「休日の措置」入力
class ItemPseudo::PjcBookingRegistrationOnHolidayInput
  include ActionView::Helpers::DateHelper
  include ERB::Util
  include GetText

  bindtextdomain("database")

  def initialize(item)
  end

  def to_data(it, &block)
    it.reg_on_holiday ||= "2"
    space = "&nbsp;&nbsp;&nbsp;&nbsp;"
    html = "<table class=\"layout_box\"><tr>"
    html += "<td>"+create_radio(1,it.reg_on_holiday) + "&nbsp;" + s_("PjcSchedule|reg on holiday 1") + space+"</td>"
    html += "<td>"+create_radio(2,it.reg_on_holiday) + "&nbsp;" + s_("PjcSchedule|reg on holiday 2") + space+"</td>"
    html += "<td>"+create_radio(3,it.reg_on_holiday) + "&nbsp;" + s_("PjcSchedule|reg on holiday 3") + space+"</td>"
    html += "<td>"+create_radio(4,it.reg_on_holiday) + "&nbsp;" + s_("PjcSchedule|reg on holiday 4") + space+"</td>"
    html += "<td>"+create_button(it)+"</td>"
    html += "<td>"
    html += "<div id=\"return_entry_date\">"
    html += "<input type=\"hidden\" id=\"it_entry_date\" name=\"it[entry_date]\" value=\"#{it.entry_date}\" >"
    html += "</div>"
    html += "</td>"
    html += "</table></tr>"
  end
  
  def create_radio(value,checked_value)
    "<input id=\"it_reg_on_holiday_#{value}\" name=\"it[reg_on_holiday]\" type='radio' value='#{value}' #{value==checked_value.to_i ? "checked" : ""} >"
  end
  
  def create_button(it)
    html = "<a class=\"button reloadable_link\" href=\"#\" "
    html += "onclick=\"new Ajax.Updater('view_confirm_create',"
    html += "'/pjc_booking/confirm_create?authenticity_token=#{it.auth_token}"
    html += "',{asynchronous:true, evalScripts:true, onComplete:function(request){document.getElementById('view_confirm_create').style.display = ''; var view = $('view_confirm_create'); var view_handle = view.select('.view_handle');new Draggable(view, {handle:view_handle[0]});},parameters:Form.serialize('view_content')}); return false;\">"
    html += s_("PjcBooking|EntryDateConfirm")
    html += "</a>"
  end
end
