# -*- coding: utf-8 -*-
# default_*_id を参照して、*_members にデータの登録 or 更新をする
class DefaultMembership

  TARGETS = {
    :company      => CompanyMember,
    :organization => OrganizationMember,
    :post         => PostedTo
  }

  def initialize(targets)
    @targets = targets
  end

  def after_create(record)
    @targets.each do |name, target_klass|
      add_default_membership(record, name, target_klass)
    end
    true
  end

  def before_update(record)
    @destroy_original_membership = !record.keep_original_membership
    @targets.each do |name, target_klass|
      update_default_membership(record, name, target_klass)
    end
    true
  end

  private

  def add_default_membership(record, name, target_klass)
    check_klass = name.to_s.capitalize.constantize
    default_key = "default_#{name.to_s}_id".to_sym
    foreign_key_name = "#{name.to_s}_id"
    if check_klass.exists?(record[default_key])
      membership = target_klass.new(:domain_id       => record.domain_id,
                                    :person_id       => record.id,
                                    foreign_key_name => record[default_key],
                                    :inception       => Date.today.strftime('%Y%m%d'),
                                    :expiry          => Date.new(9999, 12, 31).strftime('%Y%m%d'))
      membership.__send__(:create_without_callbacks)
      membership.__send__(:callback, :after_create)
    end
  end

  def update_default_membership(record, name, target_klass)
    check_klass = name.to_s.capitalize.constantize
    default_key = "default_#{name.to_s}_id".to_sym
    foreign_key_name = "#{name.to_s}_id".to_sym
    old_default_value = Person.find(record.id)[default_key]
    return true if old_default_value == record[default_key]
    conditions = {
      :domain_id       => record.domain_id,
      :person_id       => record.id,
      foreign_key_name => old_default_value # old
    }
    if @destroy_original_membership && target_klass.exists?(conditions)
      membership = target_klass.find(:first, :conditions => conditions)
      if record[default_key].nil?
        membership.destroy
      else
        membership[foreign_key_name] = record[default_key] # new
        membership.inception = Date.today.strftime('%Y%m%d')
        membership.expiry    = Date.new(9999, 12, 31).strftime('%Y%m%d')
        membership.__send__(:callback, :before_update)
        membership.__send__(:update_without_callbacks)
        membership.__send__(:callback, :after_update)
      end
    else
      add_default_membership(record, name, target_klass)
    end
  end
end
