module ActiveSupport #:nodoc:
  module CoreExtensions #:nodoc:
    module String #:nodoc:
      module GetText
        def po_mangle
          str = delete("\r")
          s = ''
          if str.count("\n") > 1
            s << '""' << "\n"
            s << str.gsub('"', '\"').gsub(/^(.*)(\n|\z)/) {$2 == "\n" ? "\"#{$1}\\n\"\n" : "\"#{$1}\""}
          else
            s << '"' << str.gsub('"', '\"').sub("\n", "\\n") << '"'
          end
          s
        end
      end
    end
  end
end
