# To change this template, choose Tools | Templates
# and open the template in the editor.

module ConfigOutput::PjcWorkingReptPerProject
  def output_rows(display_id, options, session_readonly)
    result = []
    #findメソッド実行に必要な情報を全てセットする。
    options[:select] ="month_workinghour_repts.id,projects.id as project_id,
                      projects.code As projects_code, projects.name As projects_name,
                      companies.name As companies_name, organizations.name As organizations_name,
                      people.name as people_name, reporting_month,
                      sum(day_workinghour_details.task_operating_time) As sum_total_work_time"
    options[:join] = "INNER JOIN people ON people.id=month_workinghour_repts.reporting_person_id
                      INNER JOIN companies ON companies.id=people.default_company_id
                      INNER JOIN organizations ON organizations.id=people.default_organization_id
                      INNER JOIN day_workinghour_repts ON day_workinghour_repts.month_workinghour_rept_id=month_workinghour_repts.id
                      INNER JOIN day_workinghour_details ON day_workinghour_details.day_workinghour_rept_id=day_workinghour_repts.id
                      INNER JOIN projects ON projects.id=day_workinghour_details.project_id"
    options[:group] = "day_workinghour_details.project_id, reporting_person_id, reporting_month"
    options[:order] = "projects.code ASC, reporting_month ASC, people.phonetic DESC"

    #項目の並び順を取得してselect句を組み立てる。
    selects =[]
    config = ConfigOutput.find_by_display_to_list_id(display_id)
    output_items = config.config_output_items
    output_items.select(&:enabled?).each do |output_item|
      case output_item.item.model_name
      when "Project"
        selects << "projects.#{output_item.item.column_name} as projects_#{output_item.item.column_name}"
      when "PjcCompany"
        selects << "companies.#{output_item.item.column_name} as companies_name"
      when "PjcOrganization"
        selects << "organizations.#{output_item.item.column_name} as organizations_name"
      when "PjcPerson"
        selects << "people.#{output_item.item.column_name} as people_name"
      else
        selects << output_item.item.column_name
      end
    end
    PjcMonthWorkinghourRept.find(:all, :conditions => options[:conditions],
                                 :order => options[:order_by] || options[:order],
                                 :joins => options[:join] || options[:joins], :include => options[:include],
                                 :select => options[:select],:group => options[:group]).each do|row|
      cols = []
      selects.each do |col|
        case col
        when "companies.name as companies_name"
          cols << row.companies_name
        when "organizations.name as organizations_name"
          cols << row.organizations_name
        when "people.name as people_name"
          cols << row.people_name
        when "projects.name as projects_name"
          cols << row.projects_name
        when "projects.code as projects_code"
          cols << row.projects_code
        when "sum_total_work_time"
          cols << row.sum_total_work_time
        else
          cols << applay_fixed_format(col, row.__send__("#{col}"))
        end
      end
      result << cols
    end
    return result
  end

  # 定型のフォーマット変換を適用する
  def applay_fixed_format(column_name, data, is_type_number = false)
    case
    when (/_month\z/ =~ column_name)
      data = Date.parse("#{data}01")
      month_name = s_("Date|month|#{data.strftime("%B")}")
      data = s_("Item|Date|%3$s,%1$s") % [data.year, data.month, month_name]

    when (/_day\z/ =~ column_name) , (/_date\z/ =~ column_name)
      begin
        data = Date.parse(data)
        if is_type_number then
          data = data.strftime("%Y/%m/%d")
        else
          month_name = s_("Date|month|#{data.strftime("%B")}")
          data = s_("Item|Date|%4$s %3$s,%1$s") % [data.year, data.month, data.day, month_name]
        end
      rescue
      end

    when ((/_start_time\z/ =~ column_name) or (/_end_time\z/ =~ column_name))

      if (data.index(":") == nil) and /(0[0-9]|1[0-9]|2[0-3])[0-5][0-9]/ =~ data
        data = "#{data[0,2]}:#{data[2,2]}"
      end

    when /_time\z/ =~ column_name
      data = convert_to_hour_minute_from(data)
    end

    return data
  end

  # 分数を（時間数）：（分数）の表記に変換する
  def convert_to_hour_minute_from(minute)
    if minute
      if minute.to_s == (minute.to_i).to_s
        return "#{(minute.to_i/60)}:#{sprintf("%02d",(minute.to_i%60))}"
      else
        return minute
      end
    end
  end
end
