# To change this template, choose Tools | Templates
# and open the template in the editor.

module ConfigOutput::PjcWorkingReptPerPeople
  def output_rows(display_id, options, session_readonly)
    result = []
    #findメソッド実行に必要な情報を全てセットする。
    options[:join] = [:reporting_person, {:reporting_person =>[:pjc_organization, :pjc_company]} ]
    options[:order] = "people.phonetic DESC, reporting_month ASC"

    #項目の並び順を取得してselect句を組み立てる。
    selects =[]
    config = ConfigOutput.find_by_display_to_list_id(display_id)
    output_items = config.config_output_items
    output_items.select(&:enabled?).each do |output_item|
      case output_item.item.model_name
      when "PjcCompany"
        selects << "companies.#{output_item.item.column_name} as companies_name"
      when "PjcOrganization"
        selects << "organizations.#{output_item.item.column_name} as organizations_name"
      when "PjcPerson"
        selects << "people.#{output_item.item.column_name} as people_name"
      else
        selects << output_item.item.column_name
      end
    end
    options[:select] = selects.join(',')

    PjcMonthWorkinghourRept.find(:all, :conditions => options[:conditions],
                                 :order => options[:order_by] || options[:order],
                                 :joins => options[:join] || options[:joins], :include => options[:include],
                                 :select => options[:select],:group => options[:group]).each do|row|
      cols = []
      selects.each do |col|
        case col
        when "companies.name as companies_name"
          cols << row.companies_name
        when "organizations.name as organizations_name"
          cols << row.organizations_name
        when "people.name as people_name"
          cols << row.people_name
        else
          cols << applay_fixed_format(col, row.__send__("#{col}"))
        end
      end
      result << cols
    end
    return result
  end

  # 定型のフォーマット変換を適用する
  def applay_fixed_format(column_name, data, is_type_number = false)
    case
    when (/_month\z/ =~ column_name)
      data = Date.parse("#{data}01")
      month_name = s_("Date|month|#{data.strftime("%B")}")
      data = s_("Item|Date|%3$s,%1$s") % [data.year, data.month, month_name]

    when (/_day\z/ =~ column_name) , (/_date\z/ =~ column_name)
      begin
        data = Date.parse(data)
        if is_type_number then
          data = data.strftime("%Y/%m/%d")
        else
          month_name = s_("Date|month|#{data.strftime("%B")}")
          data = s_("Item|Date|%4$s %3$s,%1$s") % [data.year, data.month, data.day, month_name]
        end
      rescue
      end

    when ((/_start_time\z/ =~ column_name) or (/_end_time\z/ =~ column_name))

      if (data.index(":") == nil) and /(0[0-9]|1[0-9]|2[0-3])[0-5][0-9]/ =~ data
        data = "#{data[0,2]}:#{data[2,2]}"
      end

    when /_time\z/ =~ column_name
      data = convert_to_hour_minute_from(data)
    end

    return data
  end

  # 分数を（時間数）：（分数）の表記に変換する
  def convert_to_hour_minute_from(minute)
    if minute
      if minute.to_s == (minute.to_i).to_s
        return "#{(minute.to_i/60)}:#{sprintf("%02d",(minute.to_i%60))}"
      else
        return minute
      end
    end
  end
end
