# 
# To change this template, choose Tools | Templates
# and open the template in the editor.

module ConfigOutput::PjcNews
  def output_rows(display_id, options, session_readonly)
    result = []
    if options[:conditions] && options[:conditions] != ""
      options[:conditions] += " and (publish_end_day = '' or publish_end_day is null or publish_end_day >= #{Time.now.strftime("%Y%m%d")})"
    else
      options[:conditions] = " (publish_end_day = '' or publish_end_day is null or publish_end_day >= #{Time.now.strftime("%Y%m%d")})"
    end
    options[:order] = " publish_start_day desc , publish_start_time desc"
    #項目の並び順を取得してselect句を組み立てる。
    selects = []
    selects_for_sql = ""
    config = ConfigOutput.find_by_display_to_list_id(display_id)
    output_items = config.config_output_items
    output_items.select(&:enabled?).each do |output_item|
      selects_for_sql += " , " if selects_for_sql != ""
      case output_item.item.column_name
      when "news_number"
        selects << output_item.item.column_name
        selects_for_sql += "news_number"
      when "bulletin_board_name"
        selects << output_item.item.column_name
        selects_for_sql += "bulletin_board_id"
      when "subject"
        selects << output_item.item.column_name
        selects_for_sql += "subject"
      when "publish_start_day"
        selects << output_item.item.column_name
        selects_for_sql += "publish_start_day"
      when "publish_end_day"
        selects << output_item.item.column_name
        selects_for_sql += "publish_end_day"
      when "publish_person_id"
        selects << output_item.item.column_name
        selects_for_sql += "publish_person_id"
      end
    end
    
    options[:select] = selects_for_sql
    
    News.find(:all, :conditions => options[:conditions],
                                 :order => options[:order_by] || options[:order],
                                 :joins => options[:join] || options[:joins], :include => options[:include],
                                 :select => options[:select],:group => options[:group]).each do|row|
      cols = []
      selects.each do |col|
        case col
          when "news_number"
            cols << row.news_number
          when "bulletin_board_name"
            b_name = PjcBulletinBoard.find(row.bulletin_board_id).name
            cols << b_name
          when "subject"
            cols << row.subject
          when "publish_start_day"
            cols << Date.parse(row.publish_start_day).strftime("%Y/%m/%d")
          when "publish_end_day"
            if row.publish_end_day == nil || row.publish_end_day == ""
              date = ""
            else
              date = Date.parse(row.publish_end_day).strftime("%Y/%m/%d")
            end
            cols << date
          when "publish_person_id"
            p_name = PjcPerson.find(row.publish_person_id).name
            cols << p_name
          end
        end
        result << cols
      end
    return result
  end
end
