# -*- coding: utf-8 -*-
# モデルのクラスに include される。
# インスタンスに対する respond_to? で正しいことが仮定されるメッセージ:
# - model_class
# - quoted_table_name
# - column_name
# - condition_pattern
# - condition_value
# - condition_hash
# - input_type
# - input_parameter
# - reference
# - option_category
# - checkbox?
# - method_chain
module Condition
  include ProjectCollaboration::PjInputOptionHelper

  module SQL

    module_function

    def every(x)
      if x.empty?
        "0 = 0" # always true
      else
        x.join(" AND ")
      end
    end

    def any(x)
      if x.empty?
        "0 = 1" # always false
      else
        x.join(" OR ")
      end
    end

    def in(quoted_table_name, column_name, values)
      if values.empty?
        "0 = 1" # false whatever
      else
        "#{quoted_table_name}.#{column_name} IN (#{values.join(',')})"
      end
    end

    def not_in(quoted_table_name, column_name, values)
      if values.empty?
        "0 = 0" # true whatever
      else
        "#{quoted_table_name}.#{column_name} NOT IN (#{values.join(',')})"
      end
    end

  end

  # 条件を文字列として返す。
  # 指定されていない場合には false を返す。
  def extract
    return false unless condition_pattern
    return false if condition_pattern == "none"
    if method_chain.blank?
      return _extract(quoted_table_name, column_name)
    else
      chain = method_chain.split('.')
      chained_model_name, chained_column_name = chain.pop.split('#')
      chained_table_name = chained_model_name.constantize.quoted_table_name
      cond = _extract(chained_table_name, chained_column_name)
      cond = "SELECT id FROM #{chained_table_name} WHERE #{cond}"
      until chain.empty?
        chained_model_name, chained_column_name = chain.pop.split('#')
        chained_table_name = chained_model_name.constantize.quoted_table_name
        cond = "SELECT id FROM #{chained_table_name} WHERE #{chained_table_name}.#{chained_column_name} IN (#{cond})"
      end
      return "(#{quoted_table_name}.#{column_name} IN (#{cond}))"
    end
  end

  def _extract(quoted_table_name, column_name)
    return false unless condition_pattern
    return false if condition_pattern == "none"
    case condition_pattern
    when "eq"
      if oracle? and text?
        x = inline_values.map {|v| "#{quoted_table_name}.#{column_name} LIKE #{self.class.connection.quote_like(v, '\\')}"}
        y = SQL.any(x)
        "(#{y})"
      elsif reference
        return SQL.in(quoted_table_name, column_name, inline_values)
      else
        if c = option_category
          qc = quote_value(c)
          x = inline_values.map do |v|
            "EXISTS (SELECT 1 FROM input_options WHERE category = #{qc} AND name_po = #{v} AND value = #{quoted_table_name}.#{column_name})"
          end
        elsif pj_input_option?
          qc = quote_value(pj_input_option_category)
          x = inline_values.map do |name_po, project_id|
            "EXISTS (SELECT 1 FROM pj_input_options WHERE category = #{qc} AND name_po = #{name_po} AND value = #{quoted_table_name}.#{column_name} AND project_id = #{project_id} AND project_id = #{quoted_table_name}.#{pj_input_option_column_name})"
          end
        else
          x = inline_values.map {|v| "#{quoted_table_name}.#{column_name} = #{v}"}
        end
        y = SQL.any(x)
        "(#{y})"
      end
    when "neq"
      if oracle? and text?
        x = inline_values.map {|v| "#{quoted_table_name}.#{column_name} NOT LIKE #{self.class.connection.quote_like(v, '\\')}"}
        y = SQL.every(x)
        "(#{y})"
      elsif reference
        return SQL.not_in(quoted_table_name, column_name, inline_values)
      else
        if c = option_category
          qc = quote_value(c)
          x = inline_values.map do |v|
            "EXISTS (SELECT 1 FROM input_options WHERE category = #{qc} AND name_po <> #{v} AND value = #{quoted_table_name}.#{column_name})"
          end
        elsif pj_input_option?
          qc = quote_value(pj_input_option_category)
          x = inline_values.map do |name_po, project_id|
            "EXISTS (SELECT 1 FROM pj_input_options WHERE category = #{qc} AND name_po <> #{name_po} AND value = #{quoted_table_name}.#{column_name} AND project_id = #{project_id} AND project_id = #{quoted_table_name}.#{pj_input_option_column_name})"
          end
        else
          x = inline_values.map {|v| "#{quoted_table_name}.#{column_name} <> #{v}"}
        end
        y = SQL.every(x)
        "(#{y})"
      end
    when "head", "tail", "include"
      if method_chain
        # fall through
      elsif reference
        return SQL.in(quoted_table_name, column_name, inline_values)
      elsif c = option_category
        qc = quote_value(c)
        x = inline_values.map do |v|
          "EXISTS (SELECT 1 FROM input_options WHERE category = #{qc} AND name_po = #{v} AND value = #{quoted_table_name}.#{column_name})"
        end
        y = SQL.any(x)
        return "(#{y})"
      elsif pj_input_option?
        qc = quote_value(pj_input_option_category)
        x = inline_values.map do |name_po, project_id|
          "EXISTS (SELECT 1 FROM pj_input_options WHERE category = #{qc} AND name_po = #{name_po} AND value = #{quoted_table_name}.#{column_name} AND project_id = #{project_id} AND project_id = #{quoted_table_name}.#{pj_input_option_column_name})"
        end
        y = SQL.any(x)
        return "(#{y})"
      end
      "(#{quoted_table_name}.#{column_name} LIKE #{inline_values.first})"
    when "exclude"
      if method_chain
        # fall through
      elsif reference
        return SQL.not_in(quoted_table_name, column_name, inline_values)
      elsif c = option_category
        qc = quote_value(c)
        x = inline_values.map do |v|
          "EXISTS (SELECT 1 FROM input_options WHERE category = #{qc} AND name_po <> #{v} AND value = #{quoted_table_name}.#{column_name})"
        end
        y = SQL.every(x)
        return "(#{y})"
      elsif pj_input_option?
        qc = quote_value(pj_input_option_category)
        x = inline_values.map do |name_po, project_id|
          "EXISTS (SELECT 1 FROM pj_input_options WHERE category = #{qc} AND name_po <> #{name_po} AND value = #{quoted_table_name}.#{column_name} AND project_id = #{project_id} AND project_id = #{quoted_table_name}.#{pj_input_option_column_name})"
        end
        y = SQL.every(x)
        return "(#{y})"
      end
      "(#{quoted_table_name}.#{column_name} IS NULL OR #{quoted_table_name}.#{column_name} NOT LIKE #{inline_values.first})"
    when "gt"
      "(#{quoted_table_name}.#{column_name} > #{inline_values.first})"
    when "ge"
      "(#{quoted_table_name}.#{column_name} >= #{inline_values.first})"
    when "le"
      "(#{quoted_table_name}.#{column_name} <= #{inline_values.first})"
    when "lt"
      "(#{quoted_table_name}.#{column_name} < #{inline_values.first})"
    when "null"
      if model_class.columns_hash[column_name].type == :string # YAGNI
        "(#{quoted_table_name}.#{column_name} IS NULL OR #{quoted_table_name}.#{column_name} = '')"
      else
        "(#{quoted_table_name}.#{column_name} IS NULL)"
      end
    when "not-null"
      if model_class.columns_hash[column_name].type == :string # YAGNI
        "(#{quoted_table_name}.#{column_name} IS NOT NULL AND #{quoted_table_name}.#{column_name} <> '')"
      else
        "(#{quoted_table_name}.#{column_name} IS NOT NULL)"
      end
    when "custom"
      "(#{condition_value.split(';').first})" % condition_hash
    else
      raise ArgumentError, "unknown condition_pattern: #{condition_pattern}"
    end
  end

  def inline_values
    case condition_pattern
    when "eq", "neq"
      raw = (condition_value.empty?) ? [""] : condition_value.split(" ")
      if method_chain
        # fall through
      elsif r = reference
        return raw.map {|name| r.find(:all).select {|x| x.name == name}.map(&:id)}.flatten
      elsif c = option_category
        return raw.map {|name| InputOption.name_po_with_category_and_name(c, name)}
      elsif pj_input_option?
        return raw.map {|name| PjInputOption.pair_with_category_and_name(pj_input_option_category, name)}
      elsif checkbox?
        ons  = %w|ON On on|
        offs = %w|OFF Off off|
        on, off = input_parameter.split(",")
        ons.unshift(on) if on
        offs.unshift(off) if off
        return raw.map do |x|
          if ons.include?(x)
            self.class.connection.quoted_true
          elsif offs.include?(x)
            self.class.connection.quoted_false
          else
            quote_value x
          end
        end
      elsif date?
        raw = raw.map {|v| fit_into_internal_date_format(v)}
      elsif year_month?
        raw = raw.map {|v| fit_into_internal_year_month_format(v)}
      end
    when "head"
      if method_chain
        raw = [condition_value + "%"]
      elsif r = reference
        return r.find(:all).select {|x| x.name.index(condition_value) == 0}.map(&:id)
      elsif c = option_category
        return InputOption.name_pos_with_category_and_head(c, condition_value)
      elsif pj_input_option?
        return PjInputOption.pairs_with_category_and_head(pj_input_option_category, condition_value)
      elsif date?
        raw = ["#{fit_into_internal_date_sub(condition_value)}%"]
      elsif year_month?
        raw = ["#{fit_into_internal_year_month_sub(condition_value)}%"]
      else
        raw = [condition_value + "%"]
      end
    when "tail"
      if method_chain
        raw = ["%" + condition_value]
      elsif r = reference
        return r.find(:all).select {|x| x.name.rindex(condition_value) == x.name.length - condition_value.length}.map(&:id)
      elsif c = option_category
        return InputOption.name_pos_with_category_and_tail(c, condition_value)
      elsif c = option_category
        return PjInputOption.pairs_with_category_and_tail(c.first, condition_value)
      elsif date?
        raw = ["%#{fit_into_internal_date_sub(condition_value)}"]
      elsif year_month?
        raw = ["%#{fit_into_internal_year_month_sub(condition_value)}"]
      else
        raw = ["%" + condition_value]
      end
    when "include", "exclude"
      if method_chain
        raw = ["%" + condition_value + "%"]
      elsif r = reference
        return r.find(:all).select {|x| x.name.include?(condition_value)}.map(&:id)
      elsif c = option_category
        return InputOption.name_pos_with_category_and_include(c, condition_value)
      elsif pj_input_option?
        return PjInputOption.pairs_with_category_and_include(pj_input_option_category, condition_value)
      elsif date?
        raw = ["%#{fit_into_internal_date_sub(condition_value)}%"]
      elsif year_month?
        raw = ["%#{fit_into_internal_year_month_sub(condition_value)}%"]
      else
        raw = ["%" + condition_value + "%"]
      end
    when "ge", "le", "gt", "lt"
      if date?
        raw = [fit_into_internal_date_sub(condition_value)]
      elsif year_month?
        raw = [fit_into_internal_year_month_sub(condition_value)]
      else
        raw = [condition_value]
      end
    when "null", "not-null"
      raw = []
    end
    return raw.map {|v| quote_value v}
  end

  module_function

  def oracle?
    /(?:oracle|oci)/i =~ ActiveRecord::Base.connection.class.to_s
  end

  def text?
    :text == model_class.columns_hash[column_name].type
  end
end
