require "active_record"

# ActiveRecord::ConnectionAdapters::Column#required? を置き換えるためのモジュール。
module ColumnsExtension
  def self.included(base)
    base.extend(ClassMethods)
  end

  module ClassMethods
    def readable_columns
      c = List.find_by_model_name(self.name)
      if c
        return self.columns_hash.values_at(*c.public_items)
      else
        return content_columns
      end
    end

    def required_columns
      column_names = read_inheritable_attribute(:required_columns) || []
      return columns_hash.values_at(*column_names)
    end

    def required(*columns)
      write_inheritable_array(:required_columns, columns.map(&:to_s))
    end

    def validates_presence_of(*attr_names)
      super
      attr_names.pop if attr_names.last.is_a?(Hash)
      required(*attr_names)
    end

    def editable_columns
      return readable_columns.reject do |column|
        /\A(?:id|(?:cre|upd)ated_(?:at|by|in|on)|parent_id|lft|rgt|position|lock_version)\z/ =~ column.name
      end
    end
  end
end

class ActiveRecord::ConnectionAdapters::Column
  # <tt>required?</tt> の置き換え。
  def required?
    # return !self.null
    return self.table_class.required.include?(self.name)
  end
end

ActiveRecord::Base.__send__ :include, ColumnsExtension
