class PjcPaymentLogic < BusinessLogic
  def postprocess(action, user, x)
    unless action == :destroy
      if action == :create
        x.applicant_id = user.person.id
      end
      x.exclude_tax_amount = TaxCalculation.compute_net_of_tax(x.amount,x.account_item_id,Date.today.strftime("%Y%m%d"))
      x.tax = x.amount - x.exclude_tax_amount
      x.save!
    end
    return true
  end
end
