# To change this template, choose Tools | Templates
# and open the template in the editor.

class PjcInputOptionCategoryLogic < BusinessLogic
  # 既定の事前処理(および事後処理)
  # 何もせず <em>x</em> を返す。
  def postprocess(action, user, x, pool)
    #明細数チェック
    if pool["detail_count"] != nil && pool["detail_count"] == pool["destroy_count"]
      x.errors.add(:category,"Please input one details or more")
      return nil
    end
    pool["detail_count"] = nil
    pool["destroy_count"] = nil
    InputOption.generate_input_options(x.category)
    return x
  end
end

class PjcInputOptionValueLogic < BusinessLogic
  # 既定の事前処理(および事後処理)
  # 何もせず <em>x</em> を返す。
  def afterprocess(action, user, x, pool)
    unless pool["detail_count"]
      pool["detail_count"] = 0
      pool["destroy_count"] = 0
    end
    #明細の件数を作る
    pool["detail_count"] = pool["detail_count"] + 1
    
    if action == :destroy
      #削除数を作る
      pool["destroy_count"] = pool["destroy_count"] + 1
    end
    return x
  end
end
