class CreateAccessLogs < ActiveRecord::Migration
  def self.up
    create_table :access_logs, :domain_id => false do |t|
      t.string :uuid, :limit => 36, :primary => true
      t.float :response_time, :null => false
    end
    add_index :access_logs, :uuid
  end

  def self.down
    remove_index :access_logs, :uuid
    drop_table :access_logs
  end
end
