class CreateProjectSegments < ActiveRecord::Migration
  def self.up
    create_table :project_segments do |t|
      t.integer :project_id, :null => false
      t.string :code, :null => false
      t.string :name, :null => false
      %w|segment_end_date plan_of_start_date plan_of_end_date|.each do |name|
        t.string name.to_sym, :limit => 8
      end
    end
  end

  def self.down
    drop_table :project_segments
  end
end
