class DropGrantTargets < ActiveRecord::Migration
  def self.up
    drop_table :grant_targets
    remove_column :grant_ons, :grant_target_id
    add_column :grant_ons, :grant_targettable_id, :integer
    add_column :grant_ons, :grant_targettable_type, :string
    remove_column :permissions, :grant_target_id
    add_column :permissions, :grant_targettable_id, :integer
    add_column :permissions, :grant_targettable_type, :string
  end

  def self.down
    create_table :grant_targets do |t|
      t.column :type, :string, :null => false
      t.column :product_id, :int
      t.column :item_id, :int
      t.column :model, :string
      t.column :value, :int
    end
    add_column :grant_ons, :grant_target_id, :integer
    remove_column :grant_ons, :grant_targettable_id
    remove_column :grant_ons, :grant_targettable_type
    add_column :permissions, :grant_target_id, :integer
    remove_column :permissions, :grant_targettable_id
    remove_column :permissions, :grant_targettable_type
  end
end
