# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: tax_rates
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  inception    :string(8)     not null
#  expiry       :string(8)     not null
#  tax_rate     :float
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

class TaxRate < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor

  def self.find_by_accrual_date(accrual_date)
    find(:first, :conditions => ["inception <= ? AND ? <= expiry",
                                 accrual_date, accrual_date])
  end
end
