# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: search_conditions
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  person_id    :integer       not null
#  display_id   :integer       not null
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

# 一覧検索(汎用検索)の検索条件のモデル。
class SearchCondition < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  belongs_to :domain
  belongs_to :person
  belongs_to :display
  has_many :search_condition_items, :order => :position, :dependent => :destroy
  delegate :name, :to => :display

  # 条件節を文字列として返す。
  # 指定されていない場合には false を返す。
  def extract
    extracts = search_condition_items.inject([]) {|seed, item| (item.proper? && (x = item.extract)) ? (seed << x) : seed}
    return false if extracts.empty?
    return extracts.join(" AND ")
  end
  
  # ORDER BY 句をハッシュとして返す。
  # 指定されていない場合には false を返す。
  def options_to_order_by
    applicables = search_condition_items.reject {|item| item.order_by == 'none'}
    return false if applicables.empty?
    return {:order => applicables.map {|item| "#{item.item.column_name} #{item.order_by}"}.join(", ")}
  end
end
