# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: posts
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  company_id   :integer       not null
#  code         :string(255)   not null
#  name         :string(255)   not null
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

# 役職のモデル。
class Post < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor

  belongs_to :company

  validates_presence_of :code, :name
  validates_uniqueness_of :code

  # 名前および企業の名前を返す。
  def name_with_in
    "#{name} (#{company.name})"
  end
end
