# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: po_messages
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  type         :string(255)   not null
#  msgctxt      :string(255)
#  msgid        :text          not null
#  msgid_plural :text
#  msgid_n      :string(255)
#  modified     :boolean
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

# gettext による翻訳の対象となるメッセージのモデル。
class PoMessage < ActiveRecord::Base
  include UUIDHelper

  untranslate_all
  timestamps_as_string
  user_monitor
  has_many :po_arguments, :dependent => :destroy
  has_many :po_translations, :dependent => :destroy

  # 個人利用のためのコピーを返す。
  def private_copy
    message = self.class.new
    message.attributes = attributes
    message.msgctxt = "#{uuid}|"
    message.modified = true
    message.save!
    po_translations.each {|t| t.private_copy(message.id)}
    po_arguments.each {|a| a.private_copy(message.id)}
    return message
  end
end
