# == Schema Information
# Schema version: 20080822052847
#
# Table name: day_workinghour_repts
#
#  id                        :integer(4)      not null, primary key
#  domain_id                 :integer(4)      not null
#  month_workinghour_rept_id :integer(4)
#  reporting_date            :string(255)
#  work_or_vacation          :string(255)
#  vacation_reason           :string(255)
#  date_changed              :boolean(1)
#  work_start_time           :string(255)
#  work_end_time             :string(255)
#  break_time                :integer(4)
#  overtime_work_time        :integer(4)
#  night_work_time           :integer(4)
#  total_work_time           :integer(4)
#  notes                     :text
#  created_at                :string(14)
#  updated_at                :string(14)
#  created_by                :integer(4)
#  updated_by                :integer(4)
#  created_in                :integer(4)
#  updated_in                :integer(4)
#  lock_version              :integer(4)      default(0), not null
#

class PjcWorkingRept < ActiveRecord::Base
  set_table_name "day_workinghour_repts"

  untranslate_all
  timestamps_as_string
  user_monitor

#start free line
  belongs_to :month_workinghour_rept, :foreign_key => "month_workinghour_rept_id", :class_name=>"PjcMonthWorkinghourRept"
  has_many :details, :foreign_key => "day_workinghour_rept_id", :class_name => "PjcWorkingReptDetail", :dependent=>:destroy, :order=>"day_workinghour_details.position"
  acts_as_permissible :parent => "month_workinghour_rept"

  attr_accessor :reporting_person_id,
                :is_holiday,
                :is_new_record,
                :object_name

  validates_presence_of :reporting_person_id , :on => :create

  def validate_on_create
    if errors.empty?
      unless new_record_is_valid?
        errors.add(:reporting_date, "PjcWorkingRept|notice|The data of this day has already been registered.")
      end
    end
  end

  def validate
    if errors.empty?
      unless start_end_time_is_valid?
        errors.add(:work_end_time, "PjcWorkingRept|notice|Before at finish time from start time.")
      else
#        unless task_operating_time_is_valid?
#          errors.add(:total_work_time, "PjcWorkingRept|notice|The input at operating time is wrong.")
#        else
          unless break_time_is_valid?
            errors.add(:break_time, "PjcWorkingRept|notice|The time for rest exceeds operating time.")
          end
#        end
      end
    end
  end

  # DB用のフォーマットに整形
  def before_save
    self.break_time         = 0 if self.break_time.blank?
    self.overtime_work_time = 0 if self.overtime_work_time.blank?
    self.night_work_time    = 0 if self.night_work_time.blank?

    st_time = Time.parse(self.work_start_time) if self.work_start_time
    ed_time = Time.parse(self.work_end_time) if self.work_end_time

    self.reporting_date   = Date.parse(self.reporting_date).strftime("%Y%m%d")
    self.work_start_time  = st_time.strftime("%H%M") if st_time
    self.work_end_time    = ed_time.strftime("%H%M") if ed_time
    if self.date_changed
      ed_time = ed_time + (24 * 60 * 60 ) if ed_time
    end
    self.total_work_time  = (((ed_time-st_time)/60).to_i) - self.break_time if st_time && ed_time
    
  end

 # 新規作成時のレコード存在チェック
  def new_record_is_valid?
    reporting_yyyymmdd = Date.parse(reporting_date).strftime("%Y%m%d")
    workinghour_rept = PjcWorkingRept.find(:first, :joins=>[ :month_workinghour_rept, {:month_workinghour_rept => :reporting_person}], :conditions=>["people.id=? and reporting_date=?", reporting_person_id, reporting_yyyymmdd])
    if workinghour_rept
      return false
    end
    return true
  end

   # 開始時刻と終了時間の期間チェック
  def start_end_time_is_valid?
    if (work_or_vacation == "1") and (date_changed != true) then
      st_time = Time.parse(work_start_time)
      ed_time = Time.parse(work_end_time)
      if st_time >= ed_time then
        return false
      end
    end
    return true
  end

#  # 稼働時間の値チェック
#  def task_operating_time_is_valid?
#    unless total_work_time.blank?
#      st_time = Time.parse(work_start_time)
#      ed_time = Time.parse(work_end_time)
#      true_op_min = ((ed_time-st_time)/60).to_i
#
#      unless true_op_min == total_work_time.to_i
#        return false
#      end
#    end
#    return true
#  end

  # 休息時間の値チェック
  def break_time_is_valid?
    if (work_or_vacation == "1") && (date_changed != true) 
      st_time = Time.parse(work_start_time)
      ed_time = Time.parse(work_end_time)
      op_min = ((ed_time-st_time)/60).to_i

      br_min = break_time.blank? ? 0 :  break_time

      return (op_min-br_min) < 0 ? false : true
    end
    return true
  end

  def name
    return s_("PjcWorkingRept|title_name|name")
  end
  #end free line
end
