class PjcUser < ActiveRecord::Base
#class PjcUser  < User
  #set_table_name "users"
  #belongs_to :person, :class_name => "PjcPerson", :foreign_key => "person_id"
  #acts_as_permissible :parent => "person"

#start free line
  set_table_name "users"
  belongs_to :domain
  belongs_to :person
  has_many :permissions, :foreign_key => "user_id", :dependent => :destroy
  has_one :portal, :foreign_key => "user_id"
  has_many :default_lists, :foreign_key => "user_id", :dependent => :destroy
  has_one :default_matter, :foreign_key => "user_id", :dependent => :destroy
  belongs_to :pjc_person, :class_name=>"PjcPerson",:foreign_key => "person_id"
  acts_as_permissible :parent => "pjc_person"
  untranslate_all
  timestamps_as_string
  user_monitor

  before_create :create_password
  after_create :initialize_permissions
  #before_save :create_password

  private

  def create_password
    s = User.hashed("salt-#{Clock.now}.#{Clock.now.usec}")
        n = Time.now.utc.strftime("%Y%m%d%H%M%S")
        t = Date.today.strftime("%Y%m%d")
    self.salt =  s
    self.salted_password = User.salted_password(s,User.hashed(self.salted_password))
  end

  def name
    return s_("PjcUser|title_name|name")
  end

  def initialize_permissions
    return unless person
    person.grant_ons.each do |grant_on|
      Permission.create_with_grant_on_and_user_id_and_priority(grant_on, id, Membership::PRIORITY_PERSON)
    end
    {
     :group        => Membership::PRIORITY_GROUP,
     :organization => Membership::PRIORITY_ORGANIZATION,
     :company      => Membership::PRIORITY_COMPANY,
    }.each do |key, priority|
      c_member_class = "Pjc#{key.to_s.classify}Member".constantize
      c_member_class.find_with_period(:all, :conditions => {:person_id => person_id}).each do |member|
        member.__send__(key).grant_ons.each do |grant_on|
          Permission.create_with_grant_on_and_user_id_and_priority(grant_on, id, priority, member.inception, member.expiry)
        end
      end
    end
    person.domain.grant_ons.each do |grant_on|
      Permission.create_with_grant_on_and_user_id_and_priority(grant_on, id, Membership::PRIORITY_DOMAIN)
    end
  end
#end free line
end

