class PjcTask < ActiveRecord::Base
  set_table_name "tasks"
  timestamps_as_string
  user_monitor
#start free line
  acts_as_nested_set :scope => :segment_id
  has_many :pjc_task_evm_totals, :order => "total_date desc", :class_name =>"PjcTaskEvmTotal", :foreign_key =>"task_id", :dependent => :destroy
  has_many :details, :foreign_key =>"task_id", :class_name =>"PjcTaskMilestone", :dependent => :destroy
  has_many :pjc_task_conditions, :foreign_key =>"task_id", :dependent => :destroy
  has_many :pjc_precede_tasks, :foreign_key =>"task_id", :dependent => :destroy
  has_many :pjc_task_records,:foreign_key =>"task_id", :dependent => :destroy
  belongs_to :segment, :class_name => "PjcProjectSegment", :foreign_key => "segment_id"
  belongs_to :project, :class_name => "PjcProject", :foreign_key => "project_id"
  acts_as_permissible :parent => "segment"

  after_create :task_initial_value
  
  #　当日のデータを表示する
  def today_evm(column_name)
      if pjc_task_evm_totals.length > 0
         today = Time.now.strftime("%Y%m%d")
         selected = pjc_task_evm_totals.select{|e| e.total_date == today}
         if selected.length > 0
            return selected[0].__send__(column_name)                    #当日のデータがあったら、表示される 
         elsif pjc_task_evm_totals[0].total_date.to_i<today.to_i
            if column_name =="delayed_days_before_start"
               return calculation_for_delayed_days_before_start(self.planned_start_date.to_date,Date.today.to_date,self)
            elsif column_name =="delayed_days_until_finish"  
               return calculation_for_delayed_days_until_finish(self.planned_finish_date.to_date,Date.today.to_date,self)
            end           
            return pjc_task_evm_totals[0].__send__(column_name)      #当日が最後の日より未来だったら、最後の日のデータを表示する 
         elsif pjc_task_evm_totals[0].total_date.to_i>today.to_i
            return ""                                                   #当日が最初の日より過去だったら、空を表示する
         else
            return "" 
         end
      return ""   
      end
  end
  
  def delayed_days_before_start
      today_evm("delayed_days_before_start")
  end

  def plan_progress_rate
      today_evm("plan_progress_rate")
  end
  
  def plan_progress_rate_future(t)
      if pjc_task_evm_totals.length > 0
         selected = pjc_task_evm_totals.select{|e| e.total_date == t.strftime("%Y%m%d")}
         if selected.length > 0
            return selected[0].plan_progress_rate
         else
            return ""      
         end
      end
  end
  
  def delayed_days_until_finish
      today_evm("delayed_days_until_finish")
  end
  
  def planed_value
      today_evm("planed_value")
  end
  
  def earned_value
      today_evm("earned_value")
  end
  
  def schedule_variance
      today_evm("schedule_variance")
  end
  
  def schedule_performance_index
      today_evm("schedule_performance_index")
  end
  
  def cost_variance
      today_evm("cost_variance")
  end
  
  def cost_performance_index
      today_evm("cost_performance_index")
  end
  
  def estimate_to_comlete
      today_evm("estimate_to_comlete")
  end
  
  def estimate_at_completion
      today_evm("estimate_at_completion")
  end
  
  def variance_at_completion
      today_evm("variance_at_completion")
  end

  def precede_task_id  
  end
   
  def precede_task_id=(x)
  end
   
   # 編集画面のset_attributesに合わせるため   
  def plan_progress_rate=(x)
     x
  end
   
  def planed_value=(x)
     x
  end
  
  def task_open_and_shut(person_id,display_id)
     open_and_shut=0
     task_condition=PjcTaskCondition.find(:first,:conditions=>["task_id=? and person_id=? and display_id=?",self.id,person_id,display_id])
     if task_condition
       open_and_shut=task_condition.task_open_and_shut
     end
     return open_and_shut
  end
  # 上位タスクの情報をすべて返却する
  def parent_task_name(it,task_name)
   if task =PjcTask.find(:first,:conditions =>["id =?",it.parent_id])
       if task.data_type == "task"  
          task_name << task.name.to_s
          task.parent_task_name(task,task_name)
       end
   end          
   return task_name
  end
   
  def project_name
      project =Project.find(:first,:conditions =>["id =?",self.project_id])
      if project
        return project.name
      else
        return ""       
      end
  end
   
  def segment_name
      segment =ProjectSegment.find(:first,:conditions =>["id =?",self.segment_id])
      if segment
        return segment.name
      else
        return ""       
      end
  end
   
   def project_code
      project =Project.find(:first,:conditions =>["id =?",self.project_id])
      if project
        return project.code
      else
        return ""       
      end
   end
   
   def segment_code
      segment =ProjectSegment.find(:first,:conditions =>["id =?",self.segment_id])
      if segment
        return segment.code
      else
        return ""       
      end
   end
   # タスクの担当者名を返却する
   def task_person_name
      person_name =""
      if person=Person.find(:first,:conditions =>["id =?",self.person_in_charge_of_work_id])
         person_name =person.name
      end
      return person_name
   end

   # 当日のカラムを返す,tは当日の日付
   def date_total(rank_task,t,column_name)
     evm =PjcTaskEvmTotal.find(:first,:conditions =>{:task_id => rank_task.id,:total_date =>t.strftime("%Y%m%d").to_i})
     if evm
       return evm.__send__(column_name).to_i
     else
       data_first_day =PjcTaskEvmTotal.minimum(:total_date,:conditions =>{:task_id => rank_task.id})
       if data_first_day && data_first_day.to_i >t.strftime("%Y%m%d").to_i
         return 0
       elsif data_last =PjcTaskEvmTotal.find(:first,:conditions =>{:task_id => rank_task.id},:order =>"total_date desc")
         return data_last.__send__(column_name).to_i
       end
     end
     return 0
   end
   
   # 新規登録するとき自分を呼ぶ
   def new_rank_update(rank_task)
       if rank_task.data_type !="project"
         conditions = ["domain_id = ? and parent_id = ?", rank_task.domain_id, rank_task.id]
       else
         conditions = ["domain_id = ? and data_type = ? and project_id =?", rank_task.domain_id,"segment",rank_task.project_id]
       end
       if rank_task
         # 上位タスクの重みを削除
         if (rank_task.children && rank_task.children !=[]) || rank_task.data_type =="project"
          rank_task.task_weight = nil
         else
          rank_task.task_weight =1
         end
         if rank_task.data_type !="project"
           # 予定開始日の集計計算
           rank_task.planned_start_date =PjcTask.minimum(:planned_start_date, :conditions => ["domain_id = ? and parent_id = ? and planned_start_date > ?", rank_task.domain_id, rank_task.id, 0])
           # 予定終了日の集計計算
           rank_task.planned_finish_date =PjcTask.maximum(:planned_finish_date, :conditions => ["domain_id = ? and parent_id = ? and planned_finish_date > ?", rank_task.domain_id, rank_task.id, 0])
           # 作業開始日の集計計算
           rank_task.operation_start_date = PjcTask.minimum(:operation_start_date, :conditions => ["domain_id =? and parent_id =? and operation_start_date >?", rank_task.domain_id, rank_task.id, 0])
           # 作業終了日の集計計算
           unless PjcTask.find(:first,:conditions =>"domain_id = #{rank_task.domain_id} and parent_id =#{rank_task.id} and (operation_finish_date IS NULL or operation_finish_date='')")
              rank_task.operation_finish_date = PjcTask.maximum(:operation_finish_date, :conditions => conditions)
           else
              rank_task.operation_finish_date = nil
           end
         else
           # 予定開始日の集計計算
           rank_task.planned_start_date =PjcTask.minimum(:planned_start_date, :conditions => ["data_type =? and project_id = ? and planned_start_date > ?","segment",rank_task.project_id,0])
           # 予定終了日の集計計算
           rank_task.planned_finish_date =PjcTask.maximum(:planned_finish_date, :conditions => ["data_type =? and project_id = ? and planned_finish_date > ?","segment",rank_task.project_id,0])
           # 作業開始日の集計計算
           rank_task.operation_start_date = PjcTask.minimum(:operation_start_date, :conditions => ["data_type =? and project_id = ? and operation_start_date >?","segment",rank_task.project_id,0])
           # 作業終了日の集計計算
           unless PjcTask.find(:first,:conditions =>"data_type ='segment' and project_id =#{rank_task.project_id} and (operation_finish_date IS NULL or operation_finish_date='')")
              rank_task.operation_finish_date = PjcTask.maximum(:operation_finish_date, :conditions => conditions)
           else
              rank_task.operation_finish_date = nil
           end
         end
         #レベルの計算
         rank_task.task_level =rank_task.level
         # BACの計算
         rank_task.budget_at_completion = PjcTask.sum(:budget_at_completion, :conditions =>conditions)
         # ACの計算 ACを計算するときに、上位タスクのACがないなら下位タスクの集計として計算する
         rank_task.actual_cost = PjcTask.sum(:actual_cost, :conditions =>conditions)       
         # 進捗率の集計計算
         rank_task.progress_rate =calculation_for_progress_rate(rank_task)
         # 重み進捗率の集計計算
         rank_task.task_weight_progress_rate =calculation_for_task_weight_progress_rate(rank_task)         
         rank_task.save!
         task_evm_total_create(rank_task)
         if rank_task.data_type == "segment"
           rank_task_project = PjcTask.find(:first,:conditions =>["project_id =? and data_type =?",rank_task.project_id,"project"])
           new_rank_update(rank_task_project) if rank_task_project
         elsif rank_task.parent
           new_rank_update(rank_task.parent)
         end
       end
   end
   
   # 重み進捗率の集計計算
   def calculation_for_task_weight_progress_rate(rank_task)
     task_children = []
     if rank_task.data_type !="project"
        task_children = rank_task.all_children
     else
        task = PjcTask.find(:all,:conditions =>{:domain_id =>rank_task.domain_id,:data_type =>"segment",:project_id =>rank_task.project_id})
        if task
           task.each do |t|
             task_children += t.all_children
           end
        end
     end
     w = 0
     p = 0
     task_children.each do|task_child|
        if task_child.task_weight.to_i>0
           w +=(task_child.task_weight*(task_child.progress_rate.to_f)).to_f if task_child.progress_rate
           p +=(task_child.task_weight).to_i
        end
     end
     if (w == 0||p == 0)
       task_weight_progress_rate = nil
     else
       task_weight_progress_rate =sprintf("%.1f", (w/p))
     end
     return task_weight_progress_rate
   end
   # 進捗率の計算
   def calculation_for_progress_rate(rank_task)
       progress_rate =nil             
       if rank_task
         if rank_task.data_type != "project"
           conditions = ["domain_id = ? and parent_id = ?", rank_task.domain_id, rank_task.id]
         else
           conditions = ["domain_id = ? and data_type = ? and project_id = ?", rank_task.domain_id,"segment",rank_task.project_id]
         end
         progress_rate_sum = PjcTask.sum(:progress_rate, :conditions =>conditions)
         progress_rate_count = PjcTask.count(:id, :conditions =>conditions)
         if progress_rate_sum&&progress_rate_sum!=0&&progress_rate_count&&progress_rate_count!=0
            progress_rate = sprintf("%.1f", (progress_rate_sum/progress_rate_count).to_f)
         end
       end
       progress_rate =nil if progress_rate==0      
       return progress_rate                   
   end
   # タスクの初期値
   def task_initial_value
       s = self.planned_start_date
       f = self.planned_finish_date
       # 重みの初期値登録
       if self.task_weight =="" ||self.task_weight ==nil
          self.task_weight =1 
       end
       # 予定稼動日数の初期値計算
       if self.number_of_operating_days ==nil && (s !=""&&s !=nil) && (f !=""&& f !=nil)
          self.number_of_operating_days =((f.to_date-s.to_date+1)-Holiday.count(:conditions =>["ymd >? and ymd <?",s.gsub("/","").to_i,f.gsub("/","").to_i])).to_i    
       end
       self.save!     
   end

   # 開始遅れの計算
   def calculation_for_delayed_days_before_start(s,t,rank_task)
       if s
          if rank_task.operation_start_date && rank_task.operation_start_date.length>0
             os =rank_task.operation_start_date.to_date 
             if os>s
                holiday_counts = Holiday.count(:conditions =>["ymd >? and ymd <?",s.strftime("%Y%m%d").to_i,os.strftime("%Y%m%d").to_i])
                delayed_days_before_start =(os-s-holiday_counts).to_s 
             else
                delayed_days_before_start = nil         
             end
          elsif t
             if t>s
                holiday_counts = Holiday.count(:conditions =>["ymd >? and ymd <?",s.strftime("%Y%m%d").to_i,t.strftime("%Y%m%d").to_i])
                delayed_days_before_start =(t-s-holiday_counts).to_s 
             else
                delayed_days_before_start = nil         
             end
          end
       else
          delayed_days_before_start = nil                  
       end
       return delayed_days_before_start        
   end
   # 終了遅れの計算
   def calculation_for_delayed_days_until_finish(f,t,rank_task)
       if f
          if rank_task.operation_finish_date && rank_task.operation_finish_date.length >0
             of =rank_task.operation_finish_date.to_date 
             if of>f
                holiday_counts = Holiday.count(:conditions =>["ymd >? and ymd <?",f.strftime("%Y%m%d").to_i,of.strftime("%Y%m%d").to_i])
                delayed_days_until_finish =(of-f-holiday_counts).to_s 
             else
                delayed_days_until_finish = nil         
             end
          else
             if t&&t>f
                holiday_counts = Holiday.count(:conditions =>["ymd >? and ymd <?",f.strftime("%Y%m%d").to_i,t.strftime("%Y%m%d").to_i])
                delayed_days_until_finish =(t-f-holiday_counts).to_s 
             else
                delayed_days_until_finish =nil         
             end
          end
       else
          delayed_days_until_finish = nil         
       end
       return delayed_days_until_finish 
   end
   # PVの計算　子供タスクの場合
   def calculation_for_pv_date_children(rank_task,plan_progress_rate)
       bac = rank_task.budget_at_completion
       if bac && plan_progress_rate
          pv =(bac.to_f*plan_progress_rate.to_f)/100
       else 
          pv = 0
       end
       return pv
   end 
   # ACの計算　子供タスクの場合   
   def calculation_for_ac_date_children(rank_task,t)
       if rank_task.actual_cost
        ac =rank_task.actual_cost.to_f
       else
        ac =0
       end
       # 予測に関するの計算(実績作業開始日がある場合計算する）
       ac_of_day =0
            s =rank_task.planned_start_date.to_date
            f =rank_task.planned_finish_date.to_date
            if t >=s && ac !=0
               if Holiday.find(:first, :conditions =>{:ymd =>f.strftime("%Y%m%d").to_s}) && t==f # 終了日は休日かどうかを判断する||処理日＝＝終了日
                  holiday_counts = Holiday.count(:conditions =>["ymd >? and ymd <?",s.strftime("%Y%m%d").to_i,t.strftime("%Y%m%d").to_i])
               else
                  holiday_counts = Holiday.count(:conditions =>["ymd >? and ymd <=?",s.strftime("%Y%m%d").to_i,t.strftime("%Y%m%d").to_i])
               end
               if (t-s-holiday_counts+1).to_f >0 # 毎日のevを計算する
                  ac_of_day =ac/(t-s-holiday_counts+1).to_i                 
               end
            end
       return ac,ac_of_day
   end   
   # EVの計算　子供タスクの場合
   def calculation_for_ev_date_children(rank_task,t)
       bac = rank_task.budget_at_completion
       progress_rate = rank_task.progress_rate
       if bac && progress_rate 
          ev = (bac*progress_rate.to_f)/100
       else
          ev = 0
       end
       # 予測に関するの計算(実績作業開始日がある場合計算する）
       ev_of_day =0
            s =rank_task.planned_start_date.to_date
            f =rank_task.planned_finish_date.to_date
            if t >=s && ev !=0
               if Holiday.find(:first, :conditions =>{:ymd =>f.strftime("%Y%m%d").to_s}) && t==f # 終了日は休日かどうかを判断する||処理日＝＝終了日
                  holiday_counts = Holiday.count(:conditions =>["ymd >? and ymd <?",s.strftime("%Y%m%d").to_i,t.strftime("%Y%m%d").to_i])
               else
                  holiday_counts = Holiday.count(:conditions =>["ymd >? and ymd <=?",s.strftime("%Y%m%d").to_i,t.strftime("%Y%m%d").to_i])
               end
               if (t-s-holiday_counts+1).to_f >0 # 毎日のevを計算する
                  ev_of_day =ev/(t-s-holiday_counts+1).to_i                 
               end
            end
       return ev,ev_of_day
   end
   
   # EVMの計算　上位タスクの場合
   def calculation_for_evm_date(rank_task,t)
       task_children =[]
       if rank_task.data_type !="project"
         task_children = rank_task.children 
       else 
         tasks = PjcTask.find(:all,:conditions =>{:domain_id =>rank_task.domain_id,:data_type =>"segment",:project_id => rank_task.project_id})
         if tasks
           tasks.each do |task|
             task_children << task
           end
         end
       end
       pv = 0
       ev = 0
       ac = 0
       if task_children    
         task_children.each do|task_child|
           # EV＝子供EVの集計
           if task_child.operation_finish_date && task_child.operation_finish_date !="" && task_child.operation_finish_date.to_date <t
            if task_child.progress_rate !=0
               ev +=task_child.earned_value.to_f if task_child.earned_value
            end
           end
           p=PjcTaskEvmTotal.find(:first, :conditions =>{:domain_id =>task_child.domain_id,:total_date =>t.strftime("%Y%m%d").to_i,:task_id =>task_child.id})
           if p
             # EV＝子供EVの集計
             ev +=p.earned_value.to_f if p.earned_value
           end
           # PV＝子供PVの集計
           pv +=date_total(task_child,t,"planed_value")
           # ACは最後の日のACを計算する
           ac +=date_total(task_child,t,"actual_cost")
         end
       end
       return pv,ev,ac
   end
   
   # 新規登録するときに、予定開始日から予定終了日までのデータを作る(最下層)
   def task_evm_total_create_children(rank_task)
       if rank_task.children ==[] # 子供がない場合、更新する
         bac = rank_task.budget_at_completion
         first_end_day =[]
         rank_task.task_level =rank_task.level #タスクのレベルを更新する
         rank_task.save!
         if (rank_task.planned_start_date && rank_task.planned_start_date !="")&&(rank_task.planned_finish_date&&rank_task.planned_finish_date !="")
            s = rank_task.planned_start_date.to_date
            f = rank_task.planned_finish_date.to_date
            t =s
            if s >Date.today #未来のデータを作る
              while t<=f
                  plan_progress_rate =calculation_for_planned_progress_rate_create_children(s,f,t)
                  delayed_days_before_start =calculation_for_delayed_days_before_start(s,t,rank_task) # 開始遅れの計算
                  delayed_days_until_finish =calculation_for_delayed_days_until_finish(f,t,rank_task) # 終了遅れの計算
                  pv =calculation_for_pv_date_children(rank_task,plan_progress_rate)
                  task_evm_total = PjcTaskEvmTotal.find(:first, :conditions =>["task_id =? and total_date =?", rank_task.id,t.strftime("%Y%m%d")]) 
                  if task_evm_total
                     task_evm_total.attributes = {:plan_progress_rate =>plan_progress_rate,
                                                  :delayed_days_before_start =>delayed_days_before_start,
                                                  :delayed_days_until_finish =>delayed_days_until_finish,
                                                  :planed_value =>sprintf("%.1f",pv)}                     
                     task_evm_total.save!
                  else
                     PjcTaskEvmTotal.create(:domain_id =>rank_task.domain_id,
                                            :task_id =>rank_task.id,
                                            :total_date =>t.strftime("%Y%m%d"),
                                            :plan_progress_rate =>plan_progress_rate,
                                            :delayed_days_before_start =>delayed_days_before_start,
                                            :delayed_days_until_finish =>delayed_days_until_finish,
                                            :planed_value =>sprintf("%.1f",pv))                                    
                  end
                  t +=1                   
              end
            else
              while t<=f  #　過去からデータを作る
                  plan_progress_rate =calculation_for_planned_progress_rate_create_children(s,f,t)
                  delayed_days_before_start =calculation_for_delayed_days_before_start(s,t,rank_task) # 開始遅れの計算
                  delayed_days_until_finish =calculation_for_delayed_days_until_finish(f,t,rank_task) # 終了遅れの計算
                  pv =calculation_for_pv_date_children(rank_task,plan_progress_rate)
                  if (rank_task.operation_start_date&&rank_task.operation_start_date !="") && Date.today >=rank_task.operation_start_date.to_date && t >=Date.today
                      task_evm_total = PjcTaskEvmTotal.find(:first, :conditions =>["task_id =? and total_date =?", rank_task.id,t.strftime("%Y%m%d")]) 
                      if t ==Date.today
                         ev,ev_of_day =calculation_for_ev_date_children(rank_task,t)
                         ac,ac_of_day =calculation_for_ac_date_children(rank_task,t)
                         if ev && pv && pv !=0
                            spi = sprintf("%.2f",ev.to_f/pv.to_f)
                         else
                            spi = 0         
                         end
                         if ev && ac && ac !=0
                            cpi = sprintf("%.2f",ev.to_f/ac.to_f)
                         else
                            cpi = 0         
                         end
                         sv=(ev.to_i-pv.to_i)
                         cv=(ev.to_i-ac.to_i)
                         # 今日のデータの更新処理
                         
                         if task_evm_total
                            task_evm_total.attributes = {:plan_progress_rate =>plan_progress_rate,
                                                          :delayed_days_before_start =>delayed_days_before_start,
                                                          :delayed_days_until_finish =>delayed_days_until_finish,
                                                          :planed_value =>sprintf("%.1f",pv),:earned_value =>ev,:actual_cost =>ac,
                                                          :schedule_variance =>sv,:schedule_performance_index =>spi,
                                                          :cost_variance =>cv,:cost_performance_index =>cpi}                                              
                            task_evm_total.save!
                         else
                             PjcTaskEvmTotal.create(:domain_id =>rank_task.domain_id,
                                                    :task_id =>rank_task.id,
                                                    :total_date =>t.strftime("%Y%m%d"),
                                                    :plan_progress_rate =>plan_progress_rate,
                                                    :delayed_days_before_start =>delayed_days_before_start,
                                                    :delayed_days_until_finish =>delayed_days_until_finish,
                                                    :planed_value =>sprintf("%.1f",pv),:earned_value =>ev,:actual_cost =>ac,
                                                    :schedule_variance =>sv,:schedule_performance_index =>spi,
                                                    :cost_variance =>cv,:cost_performance_index =>cpi)                                     
                         end
                      elsif t >Date.today && Holiday.find(:first, :conditions =>{:ymd =>t.strftime("%Y%m%d").to_s}) ==nil #休日も含めて
                         if ev <= bac.to_i
                            ev +=ev_of_day # 毎日のEVの予測
                         end
                         if ev >bac.to_i 
                            ev = bac.to_i 
                            end_day =t     # 予測の最終日
                            if first_end_day==[]
                               first_end_day<<end_day 
                            end
                         end
                         unless end_day                     
                            ac +=ac_of_day # 毎日のACの予測
                         end 
                      end
                      if end_day && end_day !=first_end_day[0]
                          if task_evm_total
                             task_evm_total.attributes = {:plan_progress_rate =>plan_progress_rate,
                                                          :delayed_days_before_start =>delayed_days_before_start,
                                                          :delayed_days_until_finish =>delayed_days_until_finish,
                                                          :planed_value =>sprintf("%.1f",pv),:earned_value =>nil,:actual_cost =>nil,
                                                          :schedule_variance =>nil,:schedule_performance_index =>spi,
                                                          :cost_variance =>nil,:cost_performance_index =>cpi}                                              
                             task_evm_total.save!
                          else
                             PjcTaskEvmTotal.create(:domain_id =>rank_task.domain_id,
                                                 :task_id =>rank_task.id,
                                                 :total_date =>t.strftime("%Y%m%d"),
                                                 :plan_progress_rate =>plan_progress_rate,
                                                 :delayed_days_before_start =>delayed_days_before_start,
                                                 :delayed_days_until_finish =>delayed_days_until_finish,
                                                 :planed_value =>sprintf("%.1f",pv),:earned_value =>nil,:actual_cost =>nil,
                                                 :schedule_variance =>nil,:schedule_performance_index =>spi,
                                                 :cost_variance =>nil,:cost_performance_index =>cpi)                                     
                          end
                      elsif t>Date.today
                          if task_evm_total           
                               task_evm_total.attributes = {:plan_progress_rate =>plan_progress_rate,
                                                            :delayed_days_before_start =>delayed_days_before_start,
                                                            :delayed_days_until_finish =>delayed_days_until_finish,
                                                            :planed_value =>sprintf("%.1f",pv),:earned_value =>sprintf("%.1f",ev),:actual_cost =>sprintf("%.1f",ac),
                                                            :schedule_variance =>sprintf("%.1f",(ev-pv)),:schedule_performance_index =>spi,
                                                            :cost_variance =>sprintf("%.1f",(ev-ac)),:cost_performance_index =>cpi}                                              
                               task_evm_total.save!
                          else
                             PjcTaskEvmTotal.create(:domain_id =>rank_task.domain_id,
                                                 :task_id =>rank_task.id,
                                                 :total_date =>t.strftime("%Y%m%d"),
                                                 :plan_progress_rate =>plan_progress_rate,
                                                 :delayed_days_before_start =>delayed_days_before_start,
                                                 :delayed_days_until_finish =>delayed_days_until_finish,
                                                 :planed_value =>sprintf("%.1f",pv),:earned_value =>sprintf("%.1f",ev),:actual_cost =>sprintf("%.1f",ac),
                                                 :schedule_variance =>sprintf("%.1f",(ev-pv)),:schedule_performance_index =>spi,
                                                 :cost_variance =>sprintf("%.1f",(ev-ac)),:cost_performance_index =>cpi)                                     
                          end
                      end

                      if ev && ev.to_f>0 && rank_task.budget_at_completion && (rank_task.budget_at_completion.to_f - ev.to_f) >0
                         left_days = (rank_task.budget_at_completion.to_f - ev.to_f)/(ev_of_day).to_i unless (ev_of_day ==0 && rank_task.budget_at_completion ==nil)
                      end
                  else
                      task_evm_total = PjcTaskEvmTotal.find(:first, :conditions =>["task_id =? and total_date =?", rank_task.id,t.strftime("%Y%m%d")]) 
                      if task_evm_total
                         task_evm_total.attributes = {:plan_progress_rate =>plan_progress_rate,
                                                      :delayed_days_before_start =>delayed_days_before_start,
                                                      :delayed_days_until_finish =>delayed_days_until_finish,
                                                      :planed_value =>sprintf("%.1f",pv)}
                         if t ==Date.today && rank_task.actual_cost && rank_task.actual_cost !=""
                           task_evm_total.attributes ={:actual_cost =>rank_task.actual_cost.to_f}
                         end
                         task_evm_total.save!
                      else
                         te=PjcTaskEvmTotal.create(:domain_id =>rank_task.domain_id,
                                             :task_id =>rank_task.id,
                                             :total_date =>t.strftime("%Y%m%d"),
                                             :plan_progress_rate =>plan_progress_rate,
                                             :delayed_days_before_start =>delayed_days_before_start,
                                             :delayed_days_until_finish =>delayed_days_until_finish,
                                             :planed_value =>sprintf("%.1f",pv))
                         if t ==Date.today && rank_task.actual_cost && rank_task.actual_cost !=""
                           te.attributes ={:actual_cost =>rank_task.actual_cost.to_f}
                           te.save!
                         end                     
                      end
                  end
                  t +=1 
              end            
            end
            # 予測のデータを作る
  #          if left_days && left_days <=365
  #             future_day =s.tomorrow
  #             while ev <=rank_task.budget_at_completion.to_f
  #                 task_evm_total = TaskEvmTotal.find(:first, :conditions =>["task_id =? and total_date =?", rank_task.id,future_day.strftime("%Y%m%d")]) 
  #                 if task_evm_total
  #                    task_evm_total.attributes = {:earned_value =>sprintf("%.1f",(ev +ev_of_day)),
  #                                                 :actual_cost =>sprintf("%.1f",(ac +ac_of_day))}                     
  #                    task_evm_total.save!
  #                 else
  #                       TaskEvmTotal.create(:domain_id =>rank_task.domain_id,
  #                                           :task_id =>rank_task.id,
  #                                           :total_date =>future_day.strftime("%Y%m%d"),
  #                                           :earned_value =>sprintf("%.1f",(ev +ev_of_day)),
  #                                           :actual_cost =>sprintf("%.1f",(ac +ac_of_day)))                                                          
  #                 end
  #                 future +=1
  #                 ev +=ev_of_day
  #                 ac +=ac_of_day
  #             end 
  #          end
  #         PjcTaskEvmTotal.destroy_all("domain_id =#{rank_task.domain_id} and task_id =#{rank_task.id} and (total_date <#{s.strftime("%Y%m%d").to_i} or total_date >#{f.strftime("%Y%m%d").to_i})")
  #         elsif (rank_task.planned_start_date==nil||rank_task.planned_start_date=="") || (rank_task.planned_finish_date==nil||rank_task.planned_finish_date=="") # 予定開始日と予定終了日がない場合、EVMの情報も削除する
  #             PjcTaskEvmTotal.destroy_all("domain_id =#{rank_task.domain_id} and task_id =#{rank_task.id}")          
         end
         destroy_evm_date(rank_task)
       end
   end
   
   # 編集する時に、実績データの更新処理
   def task_evm_total_update_children(rank_task)
     if rank_task.children ==[] # 子供がない場合、更新する
       rank_task.task_level =rank_task.level #タスクのレベルを更新する
       rank_task.save!
       # 実績開始日が入力した場合
       if rank_task.operation_start_date && rank_task.operation_start_date !=""
         # 実績終了日が入力した場合、開始日から終了日までのデータを作る
         if rank_task.operation_finish_date && rank_task.operation_finish_date !=""
           os =rank_task.operation_start_date.to_date
           of =rank_task.operation_finish_date.to_date
           t =os
           while t<=of
             if rank_task.planned_start_date && rank_task.planned_start_date!=""&&rank_task.planned_finish_date&&rank_task.planned_finish_date!=""
               delayed_days_before_start =calculation_for_delayed_days_before_start(rank_task.planned_start_date.to_date,t,rank_task)  # 開始遅れの計算
               delayed_days_until_finish =calculation_for_delayed_days_until_finish(rank_task.planned_finish_date.to_date,t,rank_task) # 終了遅れの計算
             else
               delayed_days_before_start=nil
               delayed_days_until_finish=nil
             end
             task_evm_total = PjcTaskEvmTotal.find(:first, :conditions =>["task_id =? and total_date =?", rank_task.id,t.strftime("%Y%m%d")])
             unless task_evm_total
               # その日のデータがない場合、前日のデータを探し
               task_evm_total_yesterday =PjcTaskEvmTotal.find(:first, :conditions =>["task_id =? and total_date =?", rank_task.id,(t-1).strftime("%Y%m%d")])
               if task_evm_total_yesterday && (t-1)<=Date.today
                 ev =task_evm_total_yesterday.earned_value
                 ac =task_evm_total_yesterday.actual_cost
               elsif task_evm_total_t =PjcTaskEvmTotal.find(:first, :conditions =>["task_id =? and total_date =?", rank_task.id,Date.today.strftime("%Y%m%d")])
                 ev =task_evm_total_t.earned_value
                 ac =task_evm_total_t.actual_cost
               else
                 ev =nil
                 ac =nil
               end
               plan_progress_rate=nil
               pv=0
               if rank_task.planned_finish_date&&rank_task.planned_finish_date!=""
                 if rank_task.planned_finish_date.to_date<t
                   plan_progress_rate=100
                   pv=rank_task.budget_at_completion
                 elsif rank_task.planned_start_date.to_date>t
                   plan_progress_rate=0
                   pv=0
                 end
               end
               if ev && pv && pv !=0 && ev
                 spi = sprintf("%.2f",ev.to_f/pv.to_f)
               else
                 spi = 0
               end
               if ev && ac && ac !=0 && ev
                 cpi = sprintf("%.2f",ev.to_f/ac.to_f)
               else
                 cpi = 0
               end
               ev =sprintf("%.1f",ev) if ev
               ac =sprintf("%.1f",ac) if ac
               if ev
                 sv =sprintf("%.1f",(ev.to_i-pv.to_i))
               else
                 sv =nil
               end
               if ev && ac
                 cv =sprintf("%.1f",(ev.to_i-ac.to_i))
               else
                 cv =nil
               end
               task_evm_total=PjcTaskEvmTotal.create(:domain_id =>rank_task.domain_id,
                                      :task_id =>rank_task.id,
                                      :total_date =>t.strftime("%Y%m%d"),
                                      :delayed_days_before_start =>delayed_days_before_start,
                                      :delayed_days_until_finish =>delayed_days_until_finish,
                                      :planed_value =>sprintf("%.1f",pv),
                                      :earned_value =>ev,
                                      :actual_cost =>ac,
                                      :schedule_variance =>sv,
                                      :schedule_performance_index =>spi,
                                      :cost_variance =>cv,
                                      :cost_performance_index =>cpi,
                                      :plan_progress_rate =>plan_progress_rate)
             else
               if rank_task.budget_at_completion && task_evm_total.plan_progress_rate
                pv =(rank_task.budget_at_completion.to_f*task_evm_total.plan_progress_rate.to_f/100).to_f
               else
                pv=0
               end
               task_evm_total.attributes ={:delayed_days_before_start =>delayed_days_before_start,
                                           :delayed_days_until_finish =>delayed_days_until_finish,
                                           :planed_value =>sprintf("%.1f",pv)}
               task_evm_total.save!        
             end
             if t==of # 最後の日のデータを作る
               if task_evm_total # その日のデータがある場合
                  if rank_task.budget_at_completion && rank_task.progress_rate
                    ev=(rank_task.budget_at_completion.to_f*rank_task.progress_rate.to_f/100).to_f
                  else
                    ev=0
                  end
                  if rank_task.actual_cost
                    ac=rank_task.actual_cost.to_f
                  else
                    ac=0
                  end
                  if rank_task.budget_at_completion && task_evm_total.plan_progress_rate
                    pv=(rank_task.budget_at_completion.to_f*task_evm_total.plan_progress_rate.to_f/100).to_f
                  else
                    pv=0
                  end
                  if ev && pv && pv !=0
                    spi = sprintf("%.2f",ev.to_f/pv.to_f)
                  else
                    spi = 0         
                  end
                  if ev && ac && ac !=0
                    cpi = sprintf("%.2f",ev.to_f/ac.to_f)
                  else
                    cpi = 0         
                  end                  
                  task_evm_total.attributes = {:earned_value =>sprintf("%.1f",ev),:actual_cost =>sprintf("%.1f",ac),
                                               :planed_value =>sprintf("%.1f",pv),
                                               :schedule_variance =>sprintf("%.1f",(ev-pv)),:schedule_performance_index =>spi,
                                               :cost_variance =>sprintf("%.1f",(ev-ac)),:cost_performance_index =>cpi}
                  task_evm_total.save!                                                      
               end
             elsif t==Date.today
                  task_evm_total_today=PjcTaskEvmTotal.find(:first, :conditions =>["task_id =? and total_date =?", rank_task.id,t.strftime("%Y%m%d")])
                  if rank_task.budget_at_completion && rank_task.progress_rate
                    ev=(rank_task.budget_at_completion.to_f*rank_task.progress_rate.to_f/100).to_f
                  else
                    ev=0
                  end
                  if rank_task.actual_cost
                   ac=rank_task.actual_cost
                  else
                   ac =0
                  end
                  pv=task_evm_total_today.planed_value
                  if ev && pv && pv !=0
                    spi = sprintf("%.2f",ev.to_f/pv.to_f)
                  else
                    spi = 0         
                  end
                  if ev && ac && ac !=0
                    cpi = sprintf("%.2f",ev.to_f/ac.to_f)
                  else
                    cpi = 0         
                  end                  
                  task_evm_total_today.attributes = {:earned_value =>sprintf("%.1f",ev),:actual_cost =>sprintf("%.1f",ac),
                                                     :schedule_variance =>sprintf("%.1f",(ev-pv)),:schedule_performance_index =>spi,
                                                     :cost_variance =>sprintf("%.1f",(ev-ac)),:cost_performance_index =>cpi}
                  task_evm_total_today.save!                                                 
             end             
             t +=1
           end
         # 実績終了日が入力しない場合 
         # 実績開始日が過去の場合、今日までのデータを作る         
         elsif Date.today>=rank_task.operation_start_date.to_date
           os =rank_task.operation_start_date.to_date
           of =Date.today
           t =os
           while t<=of
             if rank_task.planned_start_date && rank_task.planned_start_date!=""&&rank_task.planned_finish_date&&rank_task.planned_finish_date!=""
               delayed_days_before_start =calculation_for_delayed_days_before_start(rank_task.planned_start_date.to_date,t,rank_task)  # 開始遅れの計算
               delayed_days_until_finish =calculation_for_delayed_days_until_finish(rank_task.planned_finish_date.to_date,t,rank_task) # 終了遅れの計算
             else
               delayed_days_before_start=nil
               delayed_days_until_finish=nil
             end
             task_evm_total = PjcTaskEvmTotal.find(:first, :conditions =>["task_id =? and total_date =?", rank_task.id,t.strftime("%Y%m%d")])
             unless task_evm_total
               # その日のデータがない場合、前日のデータを探し
               task_evm_total_yesterday =PjcTaskEvmTotal.find(:first, :conditions =>["task_id =? and total_date =?", rank_task.id,(t-1).strftime("%Y%m%d")])
               if task_evm_total_yesterday && (t-1)<=Date.today
                 ev =task_evm_total_yesterday.earned_value
                 ac =task_evm_total_yesterday.actual_cost
               elsif task_evm_total_t1 =PjcTaskEvmTotal.find(:first, :conditions =>["task_id =? and total_date =?", rank_task.id,Date.today.strftime("%Y%m%d")])
                 ev =task_evm_total_t1.earned_value
                 ac =task_evm_total_t1.actual_cost
               else
                 ev =nil
                 ac =nil
               end
               plan_progress_rate=nil
               pv=0
               if rank_task.planned_finish_date&&rank_task.planned_finish_date!=""
                 if rank_task.planned_finish_date.to_date<t
                   plan_progress_rate=100
                   pv=rank_task.budget_at_completion.to_f if rank_task.budget_at_completion
                 elsif rank_task.planned_start_date.to_date>t
                   plan_progress_rate=0
                   pv=0
                 end
               end
               if ev && pv && pv !=0 && ev
                 spi = sprintf("%.2f",ev.to_f/pv.to_f)
               else
                 spi = 0
               end
               if ev && ac && ac !=0 && ev
                 cpi = sprintf("%.2f",ev.to_f/ac.to_f)
               else
                 cpi = 0
               end
               pv =sprintf("%.1f",pv) if pv
               ev =sprintf("%.1f",ev) if ev
               ac =sprintf("%.1f",ac) if ac
               if ev && pv
                 sv =sprintf("%.1f",(ev.to_i-pv.to_i))
               else
                 sv =nil
               end
               if ev && ac
                 cv =sprintf("%.1f",(ev.to_i-ac.to_i))
               else
                 cv =nil
               end
               task_evm_total=PjcTaskEvmTotal.create(:domain_id =>rank_task.domain_id,
                                      :task_id =>rank_task.id,
                                      :total_date =>t.strftime("%Y%m%d"),
                                      :delayed_days_before_start =>delayed_days_before_start,
                                      :delayed_days_until_finish =>delayed_days_until_finish,
                                      :planed_value =>pv,
                                      :earned_value =>ev,
                                      :actual_cost =>ac,
                                      :schedule_variance =>sv,
                                      :schedule_performance_index =>spi,
                                      :cost_variance =>cv,
                                      :cost_performance_index =>cpi,
                                      :plan_progress_rate =>plan_progress_rate)
             else
               if rank_task.budget_at_completion && task_evm_total.plan_progress_rate
                 pv =(rank_task.budget_at_completion.to_f*task_evm_total.plan_progress_rate.to_f/100).to_f
               else
                 pv =0
               end
               task_evm_total.attributes ={:delayed_days_before_start =>delayed_days_before_start,
                                           :delayed_days_until_finish =>delayed_days_until_finish,
                                           :planed_value =>sprintf("%.1f",pv)}
               task_evm_total.save!
             end
             if t==of # 最後の日のデータを作る
               if task_evm_total # その日のデータがある場合
                  if rank_task.budget_at_completion && rank_task.progress_rate
                    ev=(rank_task.budget_at_completion.to_f*rank_task.progress_rate.to_f/100).to_f
                  else
                    ev=0
                  end
                  if rank_task.actual_cost
                    ac=rank_task.actual_cost.to_f
                  else
                    ac=0
                  end
                  if task_evm_total.planed_value
                    pv=task_evm_total.planed_value.to_f
                  else
                    pv=0
                  end
                  if ev && pv && pv !=0
                    spi = sprintf("%.2f",ev.to_f/pv.to_f)
                  else
                    spi = 0         
                  end
                  if ev && ac && ac !=0
                    cpi = sprintf("%.2f",ev.to_f/ac.to_f)
                  else
                    cpi = 0         
                  end                 
                  task_evm_total.attributes = {:earned_value =>sprintf("%.1f",ev),:actual_cost =>sprintf("%.1f",ac),
                                               :schedule_variance =>sprintf("%.1f",(ev-pv)),:schedule_performance_index =>spi,
                                               :cost_variance =>sprintf("%.1f",(ev-ac)),:cost_performance_index =>cpi}
                  task_evm_total.save!                           
               else
                  if rank_task.planned_start_date&&rank_task.planned_start_date!=""&&rank_task.planned_start_date.to_date<t
                    plan_progress_rate=100
                    if rank_task.budget_at_completion
                     pv=rank_task.budget_at_completion.to_f
                    else
                     pv=0
                    end
                  else
                    plan_progress_rate=0
                    pv=0
                  end
                  task_evm_total=PjcTaskEvmTotal.find(:first, :conditions =>["task_id =? and total_date =?", rank_task.id,t.strftime("%Y%m%d")])
                  task_evm_total.attributes = {:plan_progress_rate =>plan_progress_rate,:planed_value =>sprintf("%.1f",pv)}
                  task_evm_total.save!                                  
               end  
             end             
             t +=1
           end
         # 実績開始日が未来の場合、その日だけのデータを作る
         elsif rank_task.operation_start_date.to_date >Date.today
            t=rank_task.operation_start_date.to_date
            task_evm_total = PjcTaskEvmTotal.find(:first, :conditions =>["task_id =? and total_date =?", rank_task.id,t.strftime("%Y%m%d")])
            if rank_task.budget_at_completion && rank_task.progress_rate
              ev=(rank_task.budget_at_completion.to_f*rank_task.progress_rate.to_f/100).to_f
            end
              ac=rank_task.actual_cost.to_f if rank_task.actual_cost
            if task_evm_total       
              pv=task_evm_total.planed_value.to_f if task_evm_total.planed_value
            else
              pv=0              
            end
            if ev && pv && pv !=0
              spi = sprintf("%.2f",ev.to_f/pv.to_f)
            else
              spi = 0         
            end
            if ev && ac && ac !=0
              cpi = sprintf("%.2f",ev/ac)
            else
              cpi = 0         
            end
            ev =sprintf("%.1f",ev) if ev
            ac =sprintf("%.1f",ac) if ac
            if ev && pv
              sv =sprintf("%.1f",(ev-pv))
            else
              sv =nil
            end
            if ev && ac
              cv =sprintf("%.1f",(ev-ac))
            else
              cv =nil
            end
            unless task_evm_total         
               PjcTaskEvmTotal.create(:domain_id =>rank_task.domain_id,
                                      :task_id =>rank_task.id,
                                      :total_date =>t.strftime("%Y%m%d"),
                                      :earned_value =>ev,:actual_cost =>ac,
                                      :schedule_variance =>sv,:schedule_performance_index =>spi,
                                      :cost_variance =>cv,:cost_performance_index =>cpi)      
            else 
               task_evm_total.attributes = {:plan_progress_rate =>plan_progress_rate,:planed_value =>sprintf("%.1f",pv),
                                      :earned_value =>ev,:actual_cost =>ac,
                                      :schedule_variance =>sv,:schedule_performance_index =>spi,
                                      :cost_variance =>cv,:cost_performance_index =>cpi}
               task_evm_total.save!                                    
               
            end
         end
       elsif rank_task.planned_start_date && rank_task.planned_start_date!=""&&rank_task.planned_finish_date&&rank_task.planned_finish_date!=""
         PjcTaskEvmTotal.find(:all, :conditions =>["task_id =?",rank_task.id]).each do |p|
           p.attributes ={:earned_value =>0,:schedule_variance =>nil,:schedule_performance_index =>nil,:cost_variance =>nil,:cost_performance_index =>nil}
           if p.total_date > Date.today.strftime("%Y%m%d")
             p.attributes ={:actual_cost =>nil}
           end
           p.save!
         end
       end
       destroy_evm_date(rank_task)
     end
   end
   # 削除処理
   def destroy_evm_date(rank_task)
     array_date =[]
     if rank_task.planned_start_date&&rank_task.planned_start_date!=""
       array_date << rank_task.planned_start_date.to_i
     end
     if rank_task.planned_finish_date&&rank_task.planned_finish_date!=""
       array_date << rank_task.planned_finish_date.to_i
     end
     if rank_task.operation_start_date&&rank_task.operation_start_date!=""
       array_date << rank_task.operation_start_date.to_i
       if (rank_task.operation_finish_date ==nil || rank_task.operation_finish_date=="") && rank_task.operation_start_date.to_date < Date.today
         array_date << Date.today.strftime("%Y%m%d").to_i
       end
     end
     if rank_task.operation_finish_date&&rank_task.operation_finish_date!=""
       array_date << rank_task.operation_finish_date.to_i
     end
     begin
       if array_date !=[]
         delete_s = Date.parse(array_date.min.to_s)
         delete_f = Date.parse(array_date.max.to_s)
       else
         delete_s = nil
         delete_f = nil
       end
     rescue
       delete_s = nil
       delete_f = nil
     end
     if delete_s&&delete_f
         PjcTaskEvmTotal.destroy_all("domain_id =#{rank_task.domain_id} and task_id =#{rank_task.id} and (total_date <#{delete_s.strftime("%Y%m%d").to_i} or total_date >#{delete_f.strftime("%Y%m%d").to_i})")
     elsif ((rank_task.planned_start_date==nil||rank_task.planned_start_date=="") || 
           (rank_task.planned_finish_date==nil||rank_task.planned_finish_date==""))&&
           (rank_task.operation_start_date==nil||rank_task.operation_start_date=="")         # 予定開始日と予定終了日がない場合、EVMの情報も削除する
           PjcTaskEvmTotal.destroy_all("domain_id =#{rank_task.domain_id} and task_id =#{rank_task.id}")          
     end 
   end

   # 予定進捗率の計算（最下層の場合）
   # sは予定開始日　ｆは予定終了日　tは処理日
   def calculation_for_planned_progress_rate_create_children(s,f,t)
       # 予定開始日と予定終了日の間の休日数を計算する
       if s && s !="" && f && f !=""
         all_holiday_counts = Holiday.count(:conditions =>["ymd >? and ymd <?",s.strftime("%Y%m%d").to_i,f.strftime("%Y%m%d").to_i])
         if (f-s-all_holiday_counts+1).to_f >0 && s<=t
            plan_progress_rate_of_day =100/(f-s-all_holiday_counts+1).to_f # 毎日の予定進捗率
            # 予定開始日と処理日の間の休日数
            if Holiday.find(:first, :conditions =>{:ymd =>f.strftime("%Y%m%d").to_s}) && t==f # 終了日は休日かどうかを判断する||処理日＝＝終了日
               holiday_counts = Holiday.count(:conditions =>["ymd >? and ymd <?",s.strftime("%Y%m%d").to_i,t.strftime("%Y%m%d").to_i])
            else
               holiday_counts = Holiday.count(:conditions =>["ymd >? and ymd <=?",s.strftime("%Y%m%d").to_i,t.strftime("%Y%m%d").to_i])
            end
            # 処理日の予定進捗率 = 毎日の予定進捗率*天数
            plan_progress_rate =(plan_progress_rate_of_day)*((t-s-holiday_counts+1).to_i)          
         else
            plan_progress_rate_of_day =0 
            plan_progress_rate = 0
         end
         plan_progress_rate = sprintf("%.1f", plan_progress_rate.to_f)
       else
         plan_progress_rate =nil      
       end
       if plan_progress_rate.to_i<0
         plan_progress_rate =0
       end
       return plan_progress_rate       
   end
   
   # 新規登録するときに、予定開始日から予定終了日までのデータを作る(中間タスク)
   def task_evm_total_create(rank_task)
       if (rank_task.planned_start_date&&rank_task.planned_start_date !="") && (rank_task.planned_finish_date&&rank_task.planned_finish_date !="")
          s = rank_task.planned_start_date.to_date
          f = rank_task.planned_finish_date.to_date
          t =s
          while t<=f
              plan_progress_rate =calculation_for_planned_progress_rate_create_children(s,f,t) # 予定進捗率の計算
              delayed_days_before_start =calculation_for_delayed_days_before_start(s,t,rank_task) # 開始遅れの計算
              delayed_days_until_finish =calculation_for_delayed_days_until_finish(f,t,rank_task) # 終了遅れの計算
              pv,ev,ac = calculation_for_evm_date(rank_task,t)
              task_ev =ev.to_i
              task_sv =(ev-pv).to_i
              task_cv =(ev-ac).to_i
              task_ac =ac.to_i
              if pv && pv !=0
                 spi = sprintf("%.2f",ev/pv)
              else
                 spi = 0         
              end
              if ac && ac !=0
                 cpi = sprintf("%.2f",ev/ac)
              else
                 cpi = 0         
              end              
              task_evm_total = PjcTaskEvmTotal.find(:first, :conditions =>["task_id =? and total_date =?", rank_task.id,t.strftime("%Y%m%d")]) 
              if task_evm_total
                 task_evm_total.attributes = {:plan_progress_rate => plan_progress_rate,
                                              :delayed_days_before_start =>delayed_days_before_start,
                                              :delayed_days_until_finish =>delayed_days_until_finish,
                                              :planed_value =>sprintf("%.1f",pv),:earned_value =>task_ev,:actual_cost =>task_ac,
                                              :schedule_variance =>task_sv,:schedule_performance_index =>spi,
                                              :cost_variance =>task_cv,:cost_performance_index =>cpi}                                              
                 task_evm_total.save!
              else
                 PjcTaskEvmTotal.create(:domain_id =>rank_task.domain_id,
                                     :task_id =>rank_task.id,
                                     :total_date =>t.strftime("%Y%m%d"),
                                     :plan_progress_rate =>plan_progress_rate,
                                     :delayed_days_before_start =>delayed_days_before_start,
                                     :delayed_days_until_finish =>delayed_days_until_finish,
                                     :planed_value =>sprintf("%.1f",pv),:earned_value =>task_ev,:actual_cost =>task_ac,
                                     :schedule_variance =>task_sv,:schedule_performance_index =>spi,
                                     :cost_variance =>task_cv,:cost_performance_index =>cpi)                                     
              end            
              t +=1                   
          end
       end
       # 上位タスクの実績データを作る
       if rank_task.operation_start_date && rank_task.operation_start_date !=""
          # 実績終了日が入力した場合、開始日から終了日までのデータを作る
         if rank_task.operation_finish_date && rank_task.operation_finish_date !=""
            of=rank_task.operation_finish_date.to_date  
         elsif Date.today>=rank_task.operation_start_date.to_date
            of=Date.today
         else
            of=nil  
         end
         os=rank_task.operation_start_date.to_date
         t =os
         while of&&t<=of
           task_evm_total = PjcTaskEvmTotal.find(:first, :conditions =>["task_id =? and total_date =?", rank_task.id,t.strftime("%Y%m%d")]) 
            if rank_task.planned_start_date && rank_task.planned_start_date!=""&&rank_task.planned_finish_date&&rank_task.planned_finish_date!=""
              delayed_days_before_start_o =calculation_for_delayed_days_before_start(rank_task.planned_start_date.to_date,nil,rank_task) # 開始遅れの計算
              delayed_days_until_finish_o =calculation_for_delayed_days_until_finish(rank_task.planned_finish_date.to_date,nil,rank_task) # 終了遅れの計算
            else
              delayed_days_before_start_o=nil
              delayed_days_before_start_o=nil
            end
            if s && f
              plan_progress_rate =calculation_for_planned_progress_rate_create_children(s,f,t) # 予定進捗率の計算
            else
              plan_progress_rate =nil
            end
            pv,ev,ac = calculation_for_evm_date(rank_task,t)
            task_ev =ev.to_i
            task_sv =(ev-pv).to_i
            task_cv =(ev-ac).to_i
            task_ac =ac.to_i
            if pv && pv !=0
               spi = sprintf("%.2f",ev/pv)
            else
               spi = 0
            end
            if ac && ac !=0
               cpi = sprintf("%.2f",ev/ac)
            else
               cpi = 0
            end
            unless task_evm_total
              PjcTaskEvmTotal.create(:domain_id =>rank_task.domain_id,
                                     :task_id =>rank_task.id,
                                     :total_date =>t.strftime("%Y%m%d"),
                                     :plan_progress_rate =>plan_progress_rate,
                                     :delayed_days_before_start =>delayed_days_before_start_o,
                                     :delayed_days_until_finish =>delayed_days_until_finish_o,
                                     :planed_value =>sprintf("%.1f",pv),:earned_value =>task_ev,:actual_cost =>task_ac,
                                     :schedule_variance =>task_sv,:schedule_performance_index =>spi,
                                     :cost_variance =>task_cv,:cost_performance_index =>cpi)
            else
              task_evm_total.attributes = {:plan_progress_rate => plan_progress_rate,
                                           :delayed_days_before_start =>delayed_days_before_start_o,
                                           :delayed_days_until_finish =>delayed_days_until_finish_o,
                                           :planed_value =>sprintf("%.1f",pv),:earned_value =>task_ev,:actual_cost =>task_ac,
                                           :schedule_variance =>task_sv,:schedule_performance_index =>spi,
                                           :cost_variance =>task_cv,:cost_performance_index =>cpi}
              task_evm_total.save!
            end
            t +=1
         end
       end
       destroy_evm_date(rank_task)
   end
   
   # BATCH処理、今日のデータの更新処理
   def batch_data_update(rank_task)
      t=Date.today
      task_evm_data_today=PjcTaskEvmTotal.find(:first, :conditions =>["task_id =? and total_date =?",rank_task.id,t.strftime("%Y%m%d")])
      task_evm_data_yesterday=PjcTaskEvmTotal.find(:first, :conditions =>["task_id =? and total_date =?",rank_task.id,(t-1).strftime("%Y%m%d")])
      if task_evm_data_yesterday   # 昨日のデータが存在する場合
        if task_evm_data_today
           if task_evm_data_today.planed_value&&task_evm_data_today.planed_value.to_i !=0
             schedule_performance_index=(task_evm_data_yesterday.earned_value/task_evm_data_today.planed_value).to_i
           else
             schedule_performance_index=0      
           end
           if task_evm_data_yesterday.earned_value && task_evm_data_today.planed_value
             sv =(task_evm_data_yesterday.earned_value-task_evm_data_today.planed_value).to_i
           else
             sv =nil
           end
           task_evm_data_today.attributes ={:earned_value =>task_evm_data_yesterday.earned_value,
                                            :actual_cost =>task_evm_data_yesterday.actual_cost,
                                            :schedule_variance =>sv,
                                            :schedule_performance_index =>schedule_performance_index,
                                            :cost_variance =>task_evm_data_yesterday.cost_variance,
                                            :cost_performance_index =>task_evm_data_yesterday.cost_performance_index}
        else
           if task_evm_data_yesterday.delayed_days_until_finish&&task_evm_data_yesterday.delayed_days_until_finish.to_i!=0
             delayed_days_until_finish=task_evm_data_yesterday.delayed_days_until_finish+1
           else
             delayed_days_until_finish=nil            
           end
           PjcTaskEvmTotal.create(:domain_id =>rank_task.domain_id,
                                   :task_id =>rank_task.id,
                                   :total_date =>t.strftime("%Y%m%d"),
                                   :plan_progress_rate =>task_evm_data_yesterday.plan_progress_rate,
                                   :delayed_days_before_start =>task_evm_data_yesterday.delayed_days_before_start,
                                   :delayed_days_until_finish =>delayed_days_until_finish,
                                   :planed_value =>task_evm_data_yesterday.planed_value,
                                   :earned_value =>task_evm_data_yesterday.earned_value,
                                   :actual_cost =>task_evm_data_yesterday.actual_cost,
                                   :schedule_variance =>task_evm_data_yesterday.schedule_variance,
                                   :schedule_performance_index =>task_evm_data_yesterday.schedule_performance_index,
                                   :cost_variance =>task_evm_data_yesterday.cost_variance,
                                   :cost_performance_index =>task_evm_data_yesterday.cost_performance_index)
        end
      else  # 昨日のデータが存在しない場合、何も更新しない
        
      end      
   end
   # バっチ処理
   def batch_process_for_task_evm_total(rank_task)
     batch_data_update(rank_task)
     rank_task.task_evm_total_create_children(rank_task)
     rank_task.task_evm_total_update_children(rank_task)
     if rank_task.parent
       new_rank_update(rank_task.parent)
     elsif rank_task.data_type =="segment"
       p =PjcTask.find(:first,:conditions =>{:project_id =>rank_task.project_id,:data_type =>"project"})
       new_rank_update(p)
     end
   end
   
#end free line
end
