class PjcSchedule < ActiveRecord::Base
  set_table_name "schedules"
  acts_as_permissible :parent => "person"
  timestamps_as_string
  user_monitor
  #start free line
  belongs_to :person , :class_name=>"PjcPerson" ,:foreign_key => "person_id"
  belongs_to :schedule_division , :class_name => "PjcScheduleDivision" 
  has_many :details, :class_name => 'PjcScheduleParticipant', :foreign_key => "schedule_id" ,:include => "person", :order => "people.phonetic" # ,:dependent => :destroy
  has_many :bookings,:class_name => 'PjcBooking' ,:foreign_key => "schedule_id" , :dependent => :destroy
  after_save :bookings_delete
  attr_accessor :division_symbol , 
                  :division_color_rgb , 
                  :shadow_schedule ,
                  :schedule_entry_kind ,
                  :schedule_entry_kind_week,
                  :schedule_entry_kind_wday,
                  :schedule_entry_kind_day,
                  :schedule_entry_kind_wday_0,
                  :schedule_entry_kind_wday_1,
                  :schedule_entry_kind_wday_2,
                  :schedule_entry_kind_wday_3,
                  :schedule_entry_kind_wday_4,
                  :schedule_entry_kind_wday_5,
                  :schedule_entry_kind_wday_6,
                  :reg_on_holiday,
                  :entry_date,
                  :participants,
                  :participant_names,
                  :equipments,
                  :entry_equipments,
                  :skip_permission_duplication,
                  :send_again,
                  :reroll_call,
                  :auth_token
                
  
  def bookings_delete
    if self.canceled == true
      bookings = PjcBooking.find(:all, :conditions=>{:schedule_id=> self.id})
      if bookings != nil && bookings != []
        bookings.each do |b|
          begin
            b.destroy
          rescue
            next
          end
        end
      end
    end
  end
  
  def validate
    unless start_end_time_is_valid?
      errors.add(:schedule_end_time , "PjcSchedule|notice|The time must be inputed.")
    end
    unless start_end_time_comparison_is_valid?
      errors.add(:schedule_start_time , "PjcSchedule|notice|The time for schedule exceeds operating time.")
    end
    if skip_permission_duplication =="0"
      if start_end_time_is_valid? && start_end_time_comparison_is_valid?
        unless permission_duplication_is_valid?
          errors.add(:schedule_end_time , "PjcSchedule|notice|The schedule has already existed.")
        end
      end
    end
  end

  def equipment_name
    equipment = []
    bookings.each do |b|
      equipment << b.equipment.name
    end
    return equipment.join(' ')
  end

  def translation_value(message_id)
    user = User.current
    if user
      trn = PoTranslation.find(:first, :conditions=>{:po_message_id=>message_id,
          :type=>"PoTranslation#{user.person.last_language.capitalize}"})
      return trn.msgstr
    end
    return ""
  end

  def trn_kind_of_schedule
    condition = "PjcSchedule|kind of schedule " + kind_of_schedule
    translation_value(PoMessage.find(:first, :conditions=>{:msgid=>condition}).id)
  end

  def trn_importance
    translation_value(InputOption.find(:first, :conditions=>{:category=>"pjc_schedule_importance", :value=>importance}).name_po)
  end

  def period
    if schedule_start_time.include?("24")
      start_d = Date.parse(schedule_start_day).strftime("%Y/%m/%d(%a) 24:00")
    else
      start_d = Time.parse(schedule_start_day + schedule_start_time).strftime("%Y/%m/%d(%a) %H:%M")
    end
    if schedule_end_time.include?("24")
      end_d = Date.parse(schedule_end_day).strftime("%Y/%m/%d(%a) 24:00")
    else
      end_d = Time.parse(schedule_end_day + schedule_end_time).strftime("%Y/%m/%d(%a) %H:%M")
    end
    if schedule_end_day == schedule_start_day
      end_d = end_d[16,5]
    end
    return start_d + " ～ " + end_d
  end

  def cmn_note
    details.each do |d|
      return d.notes
    end
  end

  def sub_content
    return content.gsub("\n", "\n 　　　　    ")
  end

  private
  # 期間の予定が存在するかどうかをチェックする
  def permission_duplication_is_valid?
    sets =  PjcPersonalScheduleSet.find(:first ,:conditions => {:person_id => User.current.person.id} )
    if sets && sets.permission_duplication == false
      return false unless repet_data_is_valid?
    end
    return true
  end

  # 開始時刻と終了時間の存在チェック
  def start_end_time_is_valid?
    if (schedule_start_time =="" && schedule_end_time !="")||(schedule_start_time !="" && schedule_end_time =="")
      return false
    end
    return true
  end
  
  # 開始時刻と終了時間の期間チェック
  def start_end_time_comparison_is_valid?
    if (schedule_start_time !="" && schedule_end_time !="") && (schedule_start_day == schedule_end_day)
      if schedule_start_time.to_i >= schedule_end_time.to_i
        return false
      end
    end
    return true
  end

  # 開始日と終了日の重複チェック
  def repet_data_is_valid?
    # 開始日と終了日が同じ日の場合
    if schedule_start_day && schedule_end_day && schedule_start_day==schedule_end_day
      schedules =PjcSchedule.find(:all,:conditions =>["schedule_start_day <=? and schedule_end_day >=? and person_id =? and canceled IS NOT true",schedule_start_day,schedule_start_day,User.current.person.id])
      if schedules && schedules !=[]
        schedules.each do |schedule|
          unless (id && id ==schedule.id)
            return false unless repet_time_is_valid?(schedule,schedule_start_time,schedule_end_time)==true
          end
        end
        return true
      else
        return true
      end
    # 開始日と終了日が同じ日ではない場合
    else
      schedules =PjcSchedule.find(:all,:conditions =>["person_id =? and canceled IS NOT true",User.current.person.id])
      if schedules && schedules !=[]
        if schedule_entry_kind =="1"
          schedules.each do |schedule|
            unless (id && id ==schedule.id)
              if (schedule.schedule_start_day <=schedule_start_day) && (schedule.schedule_end_day >schedule_start_day)
                return false
              elsif (schedule.schedule_start_day >=schedule_start_day) && (schedule.schedule_start_day <=schedule_end_day)
                if schedule.schedule_start_day !=schedule_start_day && schedule.schedule_start_day !=schedule_end_day
                  return false
                elsif schedule.schedule_start_day ==schedule_start_day
                   if schedule.schedule_end_day >schedule_start_day
                     return false
                   elsif schedule.schedule_end_time =="" || schedule_start_time =="" || schedule.schedule_end_time >schedule_start_time
                     return false
                   end
                elsif schedule.schedule_start_day ==schedule_end_day
                   if schedule.schedule_start_time =="" || schedule_end_time =="" || schedule.schedule_start_time <schedule_end_time
                     return false
                   end
                end
              end
            end
          end
        else
          schedules.each do |schedule|
            unless (id && id ==schedule.id)
              if (schedule.schedule_start_day <=schedule_start_day) && (schedule.schedule_end_day >schedule_start_day)
                return false unless repet_time_is_valid?(schedule,schedule_start_time,schedule_end_time)==true
              elsif (schedule.schedule_start_day >=schedule_start_day) && (schedule.schedule_start_day <=schedule_end_day)
                return false unless repet_time_is_valid?(schedule,schedule_start_time,schedule_end_time)==true
              end
            end
          end
        end
        return true
      else
        return true
      end
    end
    return true
  end

  # 開始時間と終了時間の重複チェック
  def repet_time_is_valid?(schedule,schedule_start_time,schedule_end_time)
    if (schedule_start_time =="" && schedule_end_time =="")
      return false
    elsif schedule.schedule_start_time =="" && schedule.schedule_end_time ==""
      return false
    elsif (schedule.schedule_start_time <=schedule_start_time) && (schedule.schedule_end_time >schedule_start_time)
      return false
    elsif (schedule.schedule_start_time >=schedule_start_time) && (schedule.schedule_start_time <=schedule_end_time)
      return false
    else
      return true
    end
  end
  #end free line

end

