class PjcProjectSegment < ActiveRecord::Base
  set_table_name "project_segments"

  untranslate_all
  timestamps_as_string
  user_monitor
  belongs_to :project, :class_name => "PjcProject", :foreign_key => "project_id"
  
  #has_many :pjc_project_troubles, :class_name =>"PjcProjectTrouble", :foreign_key => "project_id", :dependent => :destroy
  has_many :pjc_project_troubles, :class_name =>"PjcProjectTrouble", :foreign_key => "segment_id", :dependent => :destroy
  #has_many :pjc_project_test_reports, :class_name =>"PjcProjectTestReport", :foreign_key => "project_id", :dependent => :destroy
  has_many :pjc_project_test_reports, :class_name =>"PjcProjectTestReport", :foreign_key => "segment_id", :dependent => :destroy
  #has_many :pjc_project_reviews, :class_name =>"PjcProjectReview", :foreign_key => "project_id", :dependent => :destroy
  has_many :pjc_project_reviews, :class_name =>"PjcProjectReview", :foreign_key => "segment_id", :dependent => :destroy
  #has_many :pjc_project_reports, :class_name =>"PjcProjectReport", :foreign_key => "project_id", :dependent => :destroy
  has_many :pjc_project_reports, :class_name =>"PjcProjectReport", :foreign_key => "segment_id", :dependent => :destroy
  #has_many :pjc_project_questions, :class_name =>"PjcProjectQuestion", :foreign_key => "project_id", :dependent => :destroy
  has_many :pjc_project_questions, :class_name =>"PjcProjectQuestion", :foreign_key => "segment_id", :dependent => :destroy
  #has_many :pjc_project_problems, :class_name =>"PjcProjectProblem", :foreign_key => "project_id", :dependent => :destroy
  has_many :pjc_project_problems, :class_name =>"PjcProjectProblem", :foreign_key => "segment_id", :dependent => :destroy
  #has_many :pjc_project_design_changes, :class_name =>"PjcProjectDesignChange", :foreign_key => "project_id", :dependent => :destroy
  has_many :pjc_project_design_changes, :class_name =>"PjcProjectDesignChange", :foreign_key => "segment_id", :dependent => :destroy
  #has_many :pjc_project_design_changes, :class_name =>"PjcProjectDesignChange", :foreign_key => "request_person_id", :dependent => :destroy
  #has_many :pjc_project_design_changes, :class_name =>"PjcProjectDesignChange", :foreign_key => "person_of_recovery_id", :dependent => :destroy
  has_many :pjc_tasks, :class_name =>"PjcTask", :foreign_key => "segment_id", :dependent => :destroy

  acts_as_permissible :parent => "project"
  after_create :initialize_task_segment_root
#start free line
   # 選択された場合の書式
  def picked_name
    to_text
  end

  def to_text
    "#{project.to_text} - #{name}"
  end
  private

  def initialize_task_segment_root
    PjcTask.create(:domain_id => self.domain_id,
                   :project_id =>self.project_id,
                   :segment_id =>self.id,
                   :task_level =>0,
                   :data_type =>"segment")
  end
#end free line
end
