class PjcGroup < ActiveRecord::Base
  set_table_name "groups"
  untranslate_all
  timestamps_as_string
  user_monitor

  has_many :pjc_personal_schedule_sets, :as => "def_group_of_gschedule"
  has_many :pjc_personal_schedule_sets, :as => "def_group_of_gwschedule"
  
  has_many :details, :class_name =>"PjcGroupMember", :foreign_key => "group_id", :dependent => :destroy , :order => "position"
  has_many :group_members ,:class_name =>"PjcGroupMember", :foreign_key => "group_id"
  has_many :people, :class_name => "PjcPerson", :foreign_key => "group_id",:through => :group_members
  has_many :grant_ons, :as => :roleable, :dependent => :destroy
  
  acts_as_permissible

#start free line

#end free line
end
