# == Schema Information
# Schema version: 20080822052847
#
# Table name: equipments
#
#  id                    :integer(4)      not null, primary key
#  domain_id             :integer(4)      not null
#  equipment_division_id :integer(4)
#  code                  :string(255)
#  name                  :string(255)
#  notes                 :text
#  created_at            :string(14)
#  updated_at            :string(14)
#  created_by            :integer(4)
#  updated_by            :integer(4)
#  created_in            :integer(4)
#  updated_in            :integer(4)
#  lock_version          :integer(4)      default(0), not null
#

class PjcEquipment < ActiveRecord::Base
  set_table_name "equipments"

  untranslate_all
  timestamps_as_string
  user_monitor
  acts_as_permissible

  belongs_to :division, :class_name =>"PjcEquipmentDivision", :foreign_key => "equipment_division_id"
  has_many :bookings, :class_name =>"PjcBooking", :foreign_key => "equipment_id", :dependent => :destroy
  #has_many :details, :class_name =>"PjcEquipmentPermit", :foreign_key => "header_id", :dependent => :destroy

  #validates_presence_of :equipment_division_id, :code, :name

#start free line

#end free line
end
