# == Schema Information
# Schema version: 20080822052847
#
# Table name: business_card_companies
#
#  id                    :integer(4)      not null, primary key
#  domain_id             :integer(4)      not null
#  code                  :string(255)
#  name                  :string(255)
#  phonetic              :string(255)
#  official_company_name :string(255)
#  postcode              :string(255)
#  state                 :string(255)
#  city                  :string(255)
#  address1              :string(255)
#  address2              :string(255)
#  phone_number          :string(255)
#  fax_number            :string(255)
#  url                   :string(255)
#  remarks               :text
#  created_at            :string(14)
#  updated_at            :string(14)
#  created_by            :integer(4)
#  updated_by            :integer(4)
#  created_in            :integer(4)
#  updated_in            :integer(4)
#  lock_version          :integer(4)      default(0), not null
#

# 名刺の会社情報のモデル
class PjcBusinessCardCompany < ActiveRecord::Base
  set_table_name "business_card_companies"
  
  untranslate_all
  timestamps_as_string
  user_monitor
  acts_as_permissible

  has_many :details, :class_name =>"PjcBusinessCardBranch", :foreign_key => "company_id", :dependent => :destroy
  has_many :pjc_business_cards, :class_name =>"PjcBusinessCard", :foreign_key => "company_id", :dependent => :destroy
  has_many :pjc_business_card_orgs, :class_name =>"PjcBusinessCardOrg", :foreign_key => "company_id", :dependent => :destroy

  #validates_presence_of :name


#start free line
  def name_with_in
    name
  end
  
#end free line
end
