# == Schema Information
# Schema version: 20080822052847
#
# Table name: bookings
#
#  id                         :integer(4)      not null, primary key
#  domain_id                  :integer(4)      not null
#  equipment_id               :integer(4)      not null
#  schedule_id                :integer(4)
#  person_id                  :integer(4)      not null
#  parent_booking_id          :integer(4)
#  reservation_start_day      :string(8)       not null
#  reservation_start_time     :string(8)       not null
#  reservation_end_day        :string(8)       not null
#  reservation_end_time       :string(8)       not null
#  purpose                    :string(400)
#  equipment_user             :string(400)
#  notes                      :string(400)
#  number_of_people           :integer(4)
#  edit_other                 :boolean(1)
#  regular_reservation_number :integer(4)
#  created_at                 :string(14)
#  updated_at                 :string(14)
#  created_by                 :integer(4)
#  updated_by                 :integer(4)
#  created_in                 :integer(4)
#  updated_in                 :integer(4)
#  lock_version               :integer(4)      not null
#

class PjcBooking < ActiveRecord::Base
  set_table_name "bookings"

  untranslate_all
  timestamps_as_string
  user_monitor
  acts_as_permissible :parent => "equipment"

  belongs_to :equipment, :class_name =>"PjcEquipment", :foreign_key => "equipment_id"
  belongs_to :schedule, :class_name =>"PjcSchedule", :foreign_key => "schedule_id"
  belongs_to :person
  belongs_to :parent_booking , :class_name =>"PjcBooking", :foreign_key => "parent_booking_id"

  #start free line
  attr_accessor :division_id,
                  :shadow_schedule,
                  :schedule_entry_kind,
                  :schedule_entry_kind_week,
                  :schedule_entry_kind_wday,
                  :schedule_entry_kind_day,
                  :schedule_entry_kind_wday_0,
                  :schedule_entry_kind_wday_1,
                  :schedule_entry_kind_wday_2,
                  :schedule_entry_kind_wday_3,
                  :schedule_entry_kind_wday_4,
                  :schedule_entry_kind_wday_5,
                  :schedule_entry_kind_wday_6,
                  :reg_on_holiday,
                  :entry_date,
                  :same_booking_equipment_ids,
                  :entry_equipments,
                  :auth_token

  def validate
    unless reservation_date_is_valid?
        errors.add(:reservation_end_time, "PjcBooking|notice|The beginning day and the end day are the same days.")
    end

    unless booking_is_valid?
      errors.add(:reservation_end_time, "PjcBooking|notice|The booking has already existed.")
    end
  end

  def reservation_date_is_valid?
    if (reservation_start_day == reservation_end_day) and (reservation_start_time == reservation_end_time)
      return false
    end
    return true
  end

  def booking_is_valid?
    dates_array = []
    dates_array = entry_date.split(",") unless entry_date.blank?
    equipments_array = []
    equipments_array = same_booking_equipment_ids.split(",") unless same_booking_equipment_ids.blank?
    equipments_array << equipment_id.to_s

    equipments_array.each do |e_id|
      dates_array.each do |date|
        conditions  = " (equipment_id = '#{e_id}')"
        conditions << " and ('#{Date.parse(date).strftime("%Y%m%d")}' between reservation_start_day and reservation_end_day)"
        conditions << " and ( (reservation_start_time <= '#{reservation_start_time}' and '#{reservation_start_time}' < reservation_end_time)"
        conditions << " or (reservation_start_time < '#{reservation_end_time}' and '#{reservation_end_time}' <= reservation_end_time))"
        conditions << " and (id <> '#{id}')" unless id.blank?
        if PjcBooking.find(:first, :select=>"id", :conditions=>conditions)
          return false
        end
      end
    end
    return true
  end

  def name
    return s_("PjcBooking|title_name|name")
  end
  #end free line
end
