class PjcApplyingFrameworkToTask < ActiveRecord::Base
  set_table_name "tasks"
  timestamps_as_string
  user_monitor
  acts_as_permissible :parent => "segment"

  belongs_to :project, :class_name => "PjcProject", :foreign_key => "project_id"
  belongs_to :segment, :class_name => "PjcProjectSegment", :foreign_key => "segment_id"

  #start free line
  attr_accessor :default_id,:default_parent_id , :default_tree , :lft_id, :rgt_id ,:applying_checked ,:applying_disabled 
  
  
  def self.find_or_create_project(project_id)

    #登録プロジェクトの存在をチェックします。
    project_task = PjcApplyingFrameworkToTask.find( 
                     :first ,
                     :conditions => {:project_id => project_id , 
                                     :data_type => "project" })
    unless project_task
      project_task = PjcApplyingFrameworkToTask.new
      project_task.project_id = project_id
      project_task.data_type = "project"
      project_task.task_level = 0
      project_task.lft = 1
      project_task.rgt = 2
      project_task.save!
    end
    return project_task
  end
  
  def self.find_or_create_segment(project_id,segment_id,project_task_id)
    segment_task = PjcApplyingFrameworkToTask.find( 
                 :first ,
                 :conditions => {:project_id => project_id , 
                                 :segment_id => segment_id ,
                                 :data_type => "segment"})
    unless segment_task
      segment_task = PjcApplyingFrameworkToTask.new
      segment_task.project_id = project_id
      segment_task.segment_id = segment_id
      segment_task.data_type = "segment"
      segment_task.task_level = 0
      segment_task.parent_id = project_task_id
      finish_segment = PjcApplyingFrameworkToTask.find( 
                         :first ,
                         :conditions => {:project_id => project_id },
                         :order=>"lft desc")
      segment_task.lft = (finish_segment.lft + 1)
      segment_task.rgt = (finish_segment.lft + 2)
      segment_task.save!
    end
    return segment_task
  end
  
  def self.framework_task_to_task(framework_id,set_parent_id,set_lft_id,set_rgt_id,parent_task_leve,add_id)
    tasks = []
    PjcFrameworkTask.find(:all , 
                          :conditions => {:framework_id => framework_id} ,
                          :order => "position").each do |fw_task|
      if fw_task.parent_framework_task_id ==nil || fw_task.parent_framework_task_id ==""
        default_parent_id =set_parent_id
      else
        default_parent_id =(fw_task.parent_framework_task_id + add_id.to_i)
      end
      fw_task_id =(fw_task.id + add_id.to_i)
      child = PjcFrameworkTask.find(:first , :conditions => {:parent_framework_task_id => fw_task.id})
      tasks << PjcApplyingFrameworkToTask.new( :id => "0",
                                               :default_id => fw_task_id,
                                               :default_parent_id => default_parent_id,
                                               :lft_id => fw_task.task_level == 1 ? set_lft_id : "" ,
                                               :rgt_id => fw_task.task_level == 1 ? set_rgt_id : "" ,
                                               :default_tree => "framework" ,
                                               :parent_id => fw_task.task_level == 1 ? set_parent_id : "",
                                               :task_level => parent_task_leve.to_i + fw_task.task_level ,
                                               :task_weight => child ? "" : "1",
                                               :code => fw_task.code ,
                                               :name => fw_task.name ,
                                               :planned_start_date => "" ,
                                               :planned_finish_date => "" ,
                                               :person_in_charge_of_work_id => "" ,
                                               :applying_checked => "true", 
                                               :applying_disabled => "false")
    end
    return tasks
  end
  
  def self.segment_task_to_task(segment_id,set_parent_id,set_lft_id,set_rgt_id,parent_task_level,schedule_date,work_user,add_id)
    tasks = []
    PjcApplyingFrameworkToTask.find(:all,
                                    :conditions=>{:segment_id => segment_id, :data_type => "task"},
                                    :order => "lft").each do |task|
      if task.parent_id ==nil || task.parent_id ==""
        default_parent_id =set_parent_id
      else
        default_parent_id =(task.parent_id + add_id.to_i)
      end
      task_id =(task.id + add_id.to_i)
      tasks << PjcApplyingFrameworkToTask.new( :id =>"0",
                                               :default_id => task_id,
                                               :default_parent_id => default_parent_id,
                                               :lft_id => task.task_level == 3 ? set_lft_id : "" ,
                                               :rgt_id => task.task_level == 3 ? set_rgt_id : "" ,
                                               :default_tree => "task" ,
                                               :parent_id => task.task_level == 3 ? set_parent_id : "",
                                               :task_level => parent_task_level.to_i + task.task_level,
                                               :task_weight => task.task_weight,
                                               :code => task.code,
                                               :name => task.name,
                                               :planned_start_date => schedule_date == "plan" ? task.planned_start_date : task.operation_start_date,
                                               :planned_finish_date => schedule_date == "plan" ? task.planned_finish_date : task.operation_finish_date,
                                               :person_in_charge_of_work_id => work_user == "1" ? task.person_in_charge_of_work_id : nil,
                                               :applying_checked => "true", 
                                               :applying_disabled => "false")
    end
    return tasks
  end
  #end free line
end
