# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: pj_input_options
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  project_id   :integer       not null
#  category     :string(255)   not null
#  name_po      :integer       not null
#  value        :string(255)   not null
#  position     :integer
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

class PjInputOption < ActiveRecord::Base
  extend InputOptionFactory
  belongs_to :project
  untranslate_all
  timestamps_as_string
  user_monitor
  acts_as_translated :name
  acts_as_list :scope => 'category = #{quote_value(category)} AND project_id = #{quote_value(project_id)}'
  validates_presence_of :category, :project_id, :name_po, :value

  # <em>category</em> と <em>project_id</em> に属する選択肢の集まりを返す。
  def self.options_for_select(category, project_id, limit = nil)
    conditions = {:category => category}
    if project_id.blank?
      conditions[:original] = true
    else
      conditions[:project_id] = project_id
    end
    options = {:conditions => conditions, :order => "position,id"}
    options[:limit] = limit if limit
    find(:all, options).map {|p| [p.name, p.value]}
  end

  # 対応する値を持つ選択肢の名前を返す。
  def self.option_name(category, project_id, value)
    conditions = {:category => category, :value => value}
    if project_id.blank?
      conditions[:original] = true
    else
      conditions[:project_id] = project_id
    end
    (i = find(:first, :conditions => conditions)) && i.name
  end

  def self.pair_with_category(category, &block)
    options = find(:all, :conditions => {:category => category})
    (o = options.find(&block)) ? [o.name_po, o.project_id] : nil
  end

  def self.pairs_with_category(category, &block)
    options = find(:all, :conditions => {:category => category})
    options.select(&block).map {|o| o.name_po ? [o.name_po, o.project_id] : nil}.compact
  end

  # 対応する値を持つ選択肢の name_po と project_id の組を返す。
  def self.pair_with_category_and_name(category, name)
    pair_with_category(category) {|o| o.name == name}
  end

  # 対応する値を持つ選択肢の name_po と project_id の組の配列を返す。
  def self.pairs_with_category_and_head(category, head)
    pairs_with_category(category) {|o| o.name.index(head) == 0}
  end

  # 対応する値を持つ選択肢の name_po と project_id の組の配列を返す。
  def self.pairs_with_category_and_tail(category, tail)
    pairs_with_category(category) {|o| o.name.rindex(tail) == o.name.length - tail.length}
  end

  # 対応する値を持つ選択肢の name_po と project_id の組の配列を返す。
  def self.pairs_with_category_and_include(category, sub)
    pairs_with_category(category) {|o| o.name.include?(sub)}
  end
end
