# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: personal_groups
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  person_id    :integer       not null
#  code         :string(255)   not null
#  name         :string(255)   not null
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

# 個人グループのモデル
class PersonalGroup < ActiveRecord::Base
  untranslate_all

  belongs_to :domain
  has_many :personal_group_members, :dependent => :destroy
  has_many :people, :through => :personal_group_members

  validates_presence_of :code, :name
  validates_uniqueness_of :code

  def name_with_in
    name
  end
end
