# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: panes
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  screen_id    :integer       not null
#  width        :string(255)
#  position     :integer
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

# 格子状のレイアウトのための縦列のモデル。
class Pane < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  belongs_to :screen
  acts_as_list :scope => :screen
  has_many :cells, :order => "position", :dependent => :destroy
  has_many :portlets, :order => "position", :dependent => :destroy
end
