class News < ActiveRecord::Base
  set_table_name "news"

  timestamps_as_string
  user_monitor

  belongs_to :pjc_bulletin_board, :foreign_key => "bulletin_board_id"
  belongs_to :person, :foreign_key => "publish_person_id"

  has_many :news_readers, :order => "id", :dependent => :destroy  

  after_create :pre_news_number
  after_save :pre_news_reader
  
  acts_as_permissible :parent => "pjc_bulletin_board"

   def pre_news_reader
     old_news_readers = NewsReader.find(:all, :conditions=>{:news_id=> self.id})
     if old_news_readers && old_news_readers != []
       old_news_readers.each do |old_news_reader|
         old_news_reader.destroy
       end       
     end

     permisson_users = Permission.find_by_sql("select user_id from permissions where domain_id = #{User.current.domain_id} and grant_targettable_id = #{self.bulletin_board_id} and grant_targettable_type = 'PjcBulletinBoard' and (value = 'full' or value = 'visible') and  (inception is null or inception <= #{Time.now.strftime("%Y%m%d")}) and (expiry is null or expiry >= #{Time.now.strftime("%Y%m%d")})")
     if permisson_users && permisson_users != []
       permisson_users = permisson_users.map(&:user_id).uniq
       permisson_users.each do |u_i|
         p = PjcUser.find(:first, :select=>"domain_id, person_id",:conditions =>["id =?",u_i])
         news_reader = NewsReader.new
         news_reader.domain_id = p.domain_id
         news_reader.news_id = self.id
         news_reader.person_id = p.person_id
         news_reader.readed_status = 0
         news_reader.save!
       end
     end
   end

   def validate
     if errors.empty?
       unless user_permission?
         errors.add(:bulletin_board_id, "News|notice|The bulletin board can not be used by this user.")
       end
     end
   end

   def pre_news_number
     per_current_number = Counter.find(:first,:conditions=>{:domain_id=>self.domain_id, :table_name=> "news"})
     per_current_number.current_number += 1
     per_current_number.save!
   end

   def bulletin_board_name
     pjc_bulletin_board.name
   end

   def user_permission?
    users =PjcUser.find(:all,:conditions =>["person_id =?",publish_person_id])
    if users
      users.each do |user|
        if PjcBulletinBoard.find(bulletin_board_id).writable_for?(user.id)
          return true
        end
      end
    end
    return false
   end
end
