# -*- coding: utf-8 -*-
class NarrowingById < Narrowing

  validates_presence_of :model_name

  # シンボルの配列を返す
  def value_keys
    [:"#{model_name.underscore}_id"]
  end

  def text(values)
    id = values[:"#{model_name.underscore}_id"]
    return nil if id.blank?
    x = model_name.constantize.find(id)
    x.to_text
  rescue ActiveRecord::RecordNotFound
    nil
  end

  def condition(table_name, column_name)
    id = Narrowing.current(self, :"#{model_name.underscore}_id")
    id.blank? ? nil : "#{table_name}.#{column_name} = #{self.class.quote_value(id)}"
  end

  def name
    model_name
  end

end
