# -*- coding: utf-8 -*-
class Narrowing < ActiveRecord::Base
  untranslate_all
  belongs_to :domain
  has_many :display_narrowings, :dependent => :destroy

  validates_presence_of :controller_path, :action_name

  # キーには文字列もしくはシンボルを受け付ける。
  def self.current(narrowing, key)
    CacheEachRequest.current[:narrowing] ||= HashWithIndifferentAccess.new
    CacheEachRequest.current[:narrowing][narrowing.id] ||= HashWithIndifferentAccess.new
    h = CacheEachRequest.current[:narrowing][narrowing.id]
    h.is_a?(Hash) ? h[key] : nil
  end

  # キーには文字列もしくはシンボルを受け付ける。
  def self.set_current(narrowing, key, value)
    CacheEachRequest.current[:narrowing] ||= HashWithIndifferentAccess.new
    CacheEachRequest.current[:narrowing][narrowing.id] ||= HashWithIndifferentAccess.new
    h = CacheEachRequest.current[:narrowing][narrowing.id]
    if h.is_a?(Hash)
      h[key] = value
    else
      h = HashWithIndifferentAccess.new({key => value})
    end
  end

  # サブクラスでシンボルの配列を返すよう実装する。
  def value_keys
    raise NotImplementedError, "need to implement at each subclass"
  end

  def narrow_to(values)
    value_keys.each do |key|
      Narrowing.set_current(self, key, values[key])
    end
  end

  private

end
