# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: login_histories
#
#  id             :integer       not null, primary key
#  domain_id      :integer
#  login          :string(255)
#  password       :string(255)
#  result         :integer       not null
#  remote_address :string(255)
#  program_type   :integer       not null
#  user_id        :integer
#  created_at     :string(14)
#  updated_at     :string(14)
#  created_by     :integer
#  updated_by     :integer
#  created_in     :integer
#  updated_in     :integer
#  lock_version   :integer       default(0), not null
#

# ログイン履歴のモデル。
class LoginHistory < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  belongs_to :domain
  belongs_to :user
  validates_associated :domain, :user

  RESULTS = [
    :RESULT_UNKNOWN,
    :RESULT_LOGIN_SUCCEEDED,
    :RESULT_LOGIN_FAILED,
    :RESULT_PASSWORD_EXPIRED,
    :RESULT_LOGOUT,
    :RESULT_SESSION_TIMED_OUT,
    :RESULT_LOGIN_SKIPPED,
    :RESULT_USER_AGENT_CHANGED,
    :RESULT_MAX
  ].freeze
  RESULTS.each_with_index do |sym, n|
    const_set(sym, n)
  end
  validates_inclusion_of :result, :in => 1...RESULT_MAX

  # ログイン結果をシンボルで返す。
  def result_as_symbol
    return RESULTS[read_attribute("result")]
  end

  PROGRAM_TYPES = [
    :PROGRAM_TYPE_UNKNOWN,
    :PROGRAM_TYPE_WEB,
    :PROGRAM_TYPE_MAX
  ].freeze
  PROGRAM_TYPES.each_with_index do |sym, n|
    const_set(sym, n)
  end
  validates_inclusion_of :program_type, :in => 1...PROGRAM_TYPE_MAX

  # プログラムの型をシンボルで返す。
  def program_type_as_symbol
    return PROGRAM_TYPES[read_attribute("program_type")]
  end

  if ENV["RAILS_ENV"] != "test"
    def password
      return "[FILTERED]"
    end
  end
end
