# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: items
#
#  id                             :integer       not null, primary key
#  domain_id                      :integer       not null
#  display_id                     :integer       not null
#  code                           :string(255)   not null
#  name_po                        :integer       not null
#  type                           :string(255)   not null
#  model_name                     :string(255)
#  column_name                    :string(255)
#  method_chain                   :text
#  adapter_name                   :string(255)
#  layout                         :float
#  width                          :string(255)
#  align                          :string(255)   default("left"), not null
#  decorator                      :string(255)   default("none"), not null
#  decorator_parameter            :string(255)
#  linked                         :boolean       not null
#  link_parameter                 :string(255)
#  position                       :integer
#  direction                      :string(255)
#  condition_value                :string(255)
#  condition_pattern              :string(255)   default("none"), not null
#  selected                       :boolean
#  ordered                        :boolean
#  search                         :boolean       default(TRUE), not null
#  control                        :string(255)   default("free"), not null
#  input_type                     :string(255)
#  field_size                     :string(255)
#  input_parameter                :string(255)
#  input_initializer              :string(255)
#  input_initial_value            :string(255)
#  write_protected                :boolean
#  validates_presence             :boolean
#  validates_non_negative_integer :boolean
#  validates_integer              :boolean
#  validates_non_negative_float   :boolean
#  validates_float                :boolean
#  validates_zero                 :boolean
#  validates_upper_case           :boolean
#  validates_lower_case           :boolean
#  validates_alphabetic           :boolean
#  validates_alphanumeric         :boolean
#  validates_halfwidth_katakana   :boolean
#  validates_fullwidth            :boolean
#  validates_fullwidth_katakana   :boolean
#  validates_inclusion_chars      :boolean
#  validates_minimum_length       :boolean
#  validates_maximum_length       :boolean
#  validates_integral_length      :boolean
#  validates_fractional_length    :boolean
#  validates_year                 :boolean
#  validates_year_month           :boolean
#  validates_year_month_day       :boolean
#  validates_hour                 :boolean
#  validates_hour_minute          :boolean
#  validates_postal_code          :boolean
#  validates_phone_number         :boolean
#  validates_email                :boolean
#  validates_url                  :boolean
#  validates_minimum_number       :boolean
#  validates_period               :boolean
#  validates_future_date          :boolean
#  validates_past_date            :boolean
#  validates_uniqueness           :boolean
#  validates_row                  :boolean
#  validates_isolated             :boolean
#  validates_inclusion_chars_1    :string(255)
#  validates_minimum_length_1     :string(255)
#  validates_maximum_length_1     :string(255)
#  validates_integral_length_1    :string(255)
#  validates_integral_length_2    :string(255)
#  validates_fractional_length_1  :string(255)
#  validates_fractional_length_2  :string(255)
#  validates_minimum_number_1     :string(255)
#  validates_period_1             :string(255)
#  validates_period_2             :string(255)
#  validates_row_1                :string(255)
#  validates_row_2                :string(255)
#  validates_isolated_1           :string(255)
#  created_at                     :string(14)
#  updated_at                     :string(14)
#  created_by                     :integer
#  updated_by                     :integer
#  created_in                     :integer
#  updated_in                     :integer
#  lock_version                   :integer       default(0), not null
#

# Polymorphic な関連付けによる項目のモデル。
class ItemPolymorphic < Item
  include Condition

  validates_presence_of :column_name

  delegate :table_name, :to => :model_class

  # 種類の名前を返す。
  def type_name
    s_("rfw|Item|Polymorphic")
  end

  def picker_field(it, name)
    detail? ? "#{input_parameter}#{id}_#{name}" : "#{input_parameter}#{id}"
  end

  # ユーザーの言語での名前を返す。
  def human_name
    name.blank? ? column_name : name
  end

  # 入力が必須かどうかを判定する。
  def required?
    validates_presence? # FIXME
  end

  # (権限が許せば)インスタンスに属性を設定する。
  def set_attributes(x, attr)
    if writable?
      id_key = "#{column_name}_id"
      type_key = "#{column_name}_type"
      begin
        klass = attr[type_key].constantize
        x.__send__("#{column_name}=", klass.find_by_id(attr[id_key]))
      rescue NameError
        x.__send__("#{column_name}=", nil)
      end
    end
  end

  # カレンダー参照を行うかどうかを判定する。
  def calendar?
    false
  end

  # checkbox 形式を利用するかどうか判定する。
  def checkbox?
    false
  end

  # 外部参照を行うカラムに対応している場合はそのクラスを返す。
  # さもなくば false を返す。
  def reference(x=nil)
    x.__send__("#{column_name}_type").constantize
  end

  # 対象 <em>it</em> の表示に適したデータを返す。
  def to_data(it)
    begin
      value = it.__send__(column_name)
    rescue NoMethodError => e
      logger.warn("ERROR: ItemPolymorphic\#to_data column_name=#{column_name.inspect} it=#{it.inspect}")
      return ""
    end
    if method_chain.blank?
      return value ? value.name : ""
    else
      return resolve_method_chain(value, true)
    end
  end
end
