# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: has_manies
#
#  id                   :integer       not null, primary key
#  domain_id            :integer       not null
#  application_model_id :integer       not null
#  name                 :string(255)   not null
#  class_name           :string(255)
#  foreign_key          :string(255)
#  as_name              :string(255)
#  dependent            :string(255)
#  created_at           :string(14)
#  updated_at           :string(14)
#  created_by           :integer
#  updated_by           :integer
#  created_in           :integer
#  updated_in           :integer
#  lock_version         :integer       default(0), not null
#

class HasMany < ActiveRecord::Base
  untranslate_all

  belongs_to :domain
  belongs_to :application_model

  # コードに埋め込まれる文字列を返す。
  def code
    c = "has_many :#{name}"
    c << ", :class_name => \"#{class_name}\"" unless class_name.blank?
    c << ", :foreign_key => \"#{foreign_key}\"" unless foreign_key.blank?
    c << ", :as => :#{as_name}" unless as_name.blank?
    c << ", :dependent => :#{dependent}" unless dependent.blank?
    return c
  end
end
