# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: expense_details
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  expense_id   :integer
#  position     :integer
#  day          :integer
#  price        :integer
#  remark       :string(255)
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

# (試験用)経費情報のモデル。
# ProductDetailed 向けの従テーブルのモデルの例。
class ExpenseDetail < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  acts_as_permissible
  acts_as_list :scope => :expense
  belongs_to :header, :class_name => "Expense", :foreign_key => "expense_id"
end
