# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: expenses
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  person_id    :integer
#  year         :integer
#  month        :integer
#  note         :string(255)
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

# (試験用)経費情報のモデル。
# ProductDetailed 向けの主テーブルのクラスの例。
class Expense < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  acts_as_permissible
  has_many :details, :class_name => 'ExpenseDetail', :order => "position", :dependent => :destroy

  def year_month
    "#{year}/#{month}"
  end
end
