# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: example_works
#
#  id                 :integer       not null, primary key
#  domain_id          :integer       not null
#  example_project_id :integer
#  name               :string(255)
#  created_at         :string(14)
#  updated_at         :string(14)
#  created_by         :integer
#  updated_by         :integer
#  created_in         :integer
#  updated_in         :integer
#  lock_version       :integer       default(0), not null
#

class ExampleWork < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  belongs_to :example_project
  acts_as_permissible :parent => "example_project"
  has_many :example_issues, :dependent => :delete_all
  has_many :example_quality_assurances, :dependent => :nullify
end
