# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: displays
#
#  id                    :integer       not null, primary key
#  domain_id             :integer       not null
#  product_id            :integer       not null
#  type                  :string(255)   not null
#  name_po               :integer       not null
#  code                  :string(255)   not null
#  position              :integer
#  enabled               :boolean
#  button_new            :boolean
#  button_edit           :boolean
#  button_delete         :boolean
#  button_copy           :boolean
#  logic_path            :string(255)
#  logic_pre             :boolean
#  logic_mid             :boolean
#  logic_post            :boolean
#  logic_before          :boolean
#  logic_after           :boolean
#  person_id             :integer
#  narrowing_model_name  :string(255)
#  narrowing_column_name :string(255)
#  created_at            :string(14)
#  updated_at            :string(14)
#  created_by            :integer
#  updated_by            :integer
#  created_in            :integer
#  updated_in            :integer
#  lock_version          :integer       default(0), not null
#

# 一覧画面のモデル
class DisplayToList < Display
  include DisplayNarrowingHelper::Handler

  has_one :config_output, :dependent => :destroy

  BUTTON_TYPE = [
    [N_("rfw|Display|New"), "new"],
  ]

  # プロダクト <em>product_id</em> に属する一覧画面のうち元になるものを返す。
  # 存在しなければ nil を返す。
  def self.source_display_to_list(product_id)
    find(:first, :conditions => {
           inheritance_column => "DisplayToList",
           :product_id => product_id,
         }, :order => "position")
  end

  # 種類の名前を返す。
  def type_name
    s_("rfw|Display|List")
  end

  # 権限にしたがって利用可能かどうかを判定する。
  def available?
    product.visible?
  end

  # 画面に抽出される条件を返す。
  # SearchCondition も参照する。
  def options_to_extract(value={})
    options = (e = extract) ? {:conditions => e} : {}
    if search_condition
      if e = search_condition.extract
        if options[:conditions]
          options[:conditions] << " AND #{e}"
        else
          options[:conditions] = e
        end
      end
    end
    if narrowing?
      if e = narrowing_condition(value)
        if options[:conditions]
          options[:conditions] << " AND #{e}"
        else
          options[:conditions] = e
        end
      end
    end
    return options
  end

  # 画面でレコードを順序づける ORDER BY 句のハッシュを返す。
  def options_to_order_by
    if search_condition
      if options = search_condition.options_to_order_by
        return options
      end
    end
    orders = items.reject {|item| item.direction.blank? || item.direction =~ /none/i || item.position.blank?}
    return {} if orders.empty?
    orders = orders.sort {|i,j| (i.position && j.position) ? (i.position - j.position) : 0}
    return {:order => orders.map(&:order).compact.join(",")}
  end

  # 画面に表示される項目の条件を返す。
  def options_to_select(&block)
    column_names = ["id"]
    items.each do |i|
      if i.readable? && (!block_given? || block.call(i))
        case i
        when ItemProper, ItemPlural
          column_names |= [i.column_name]
        when ItemPolymorphic
          column_names |= ["#{i.column_name}_id", "#{i.column_name}_type"]
        when ItemPseudo
          next if i.column_name.blank?
          return {} if i.column_name == "*"
          column_names |= i.column_name.split(",")
        end
      end
    end
    return {:select => column_names.join(",")}
  end

  def query_options(value={}, &block)
    options = {}
    options.update(options_to_extract(value))
    options.update(options_to_order_by)
    options.update(options_to_select(&block))
    return options
  end

  # 選択された項目を返す。
  def selected_items
    items.select(&:selected?).sort_by(&:layout)
  end

  # 個人利用のためのコピーを返す。
  def private_copy
    user =  User.current
    raise "current user is expected" unless user
    return copy(DisplayToListPrivate, user.person_id)
  end

  # 適切な ConfigOutput のインスタンスを生成する。
  def generate_config_output
    return config_output if config_output
    user_id = User.current_id
    raise "current user is expected" unless user_id
    config_output = ConfigOutput.create!(:display_to_list_id => id,
                                         :name => name,
                                         :user_id => user_id)
    selected_items.reject {|item| item.is_a?(ItemPseudo)}.each_with_index do |item,i|
      ConfigOutputItem.create!(:config_output_id => config_output.id,
                               :item_id => item.id,
                               :name => item.name,
                               :position => i + 1,
                               :enabled => true)
    end
    return config_output
  end

  # 既定の一覧かどうかを判定する。
  def default_list?
    default_list = DefaultList.find_by_user_id_and_product_id(User.current_id, product.id)
    return default_list && id == default_list.display_id
  end

  # 汎用検索の条件が有効になっているかどうかを判定する。
  def searching?
    (search_condition && search_condition.extract) ? true : false
  end

  private

  def search_condition
    return @search_condition if defined?(@search_condition)
    return @search_condition = nil unless User.current
    @search_condition = SearchCondition.find_by_person_id_and_display_id(User.current.person_id, id)
  end

  # 画面に抽出される条件を返す。
  def extract
    extracts = items.inject([]) {|seed, item| (x = item.extract) ? (seed << x) : seed}
    return false if extracts.empty?
    return extracts.join(" AND ")
  end
  
  def initialize_button_and_name_and_items

    # Do not initialize in case of private use.
    return if person_id

    self.class::BUTTON_TYPE.each do |b|
      self.__send__ "button_#{b.last}=", true
    end

    initialize_name

    i = 1
    application_table = ApplicationTable.find(:first,:conditions => {:name => product.table_name},:order => "id")
    application_table_columns = TableColumn.find(:all , :conditions => {:table_id =>application_table.id}, :order => "id")

    application_table_columns.each do |column|
      unless ItemProper::PRIVATE_COLUMN.include?(column.name)
        # An ItemProper has a po message whose msgid comes from its column name as below.
        column_po = PoMessageSingular.find_or_create_by_msgctxt_and_msgid("", "Item|#{product.model_name}|#{column.name}")
        options = self.class::ITEM_DEFAULT_OPTIONS.merge({
          :display_id  => id,
          :code        => column.name.upcase,
          :column_name => column.name,
          :model_name => product.model_name,#追加
          :name_po     => column_po.id,
        })
        if ItemProper::HIDDEN_COLUMN.include?(column.name)
          options[:layout] = 0
        else
          options[:layout] = i
          i += 1
        end
        case column.type
        when :integer
          options[:align] = "right" unless /_id\z/ =~ column.name
        when :boolean
          options[:input_type] = "checkbox" if writable?
        when :text
          options[:input_type] = "textarea" if writable?
          options[:decorator] = "nl2br"
        end
        if writable?
          case column.name
          when /\A(company|organization|person|post|group)_id\z/
            associated_table = $1
            options[:input_parameter] = associated_table
            options[:validates_row] = true
            options[:validates_row_1] = associated_table
            options[:validates_row_2] = "id"
            if /\A(?:person|company|organization)\z/ =~ associated_table
              options[:input_initializer] = associated_table
            end
          when /\A(?:inception|expiry)\z/
            options[:input_parameter] = "calendar"
            options[:input_initializer] = "today"
            options[:validates_year_month_day] = true
          end
        end
        ItemProper.create! options
      end
    end
  end

  def copy(klass, person_id=nil)
    display = klass.new(attributes)
    display.person_id = person_id if person_id
    m = PoMessageSingular.find(name_po)
    n = m.private_copy
    display.name_po = n.id
    display.save!
    x, y = items.select(&:selected?).partition {|item| item.layout.to_i > 0}
    x.sort_by(&:layout).each_with_index do |item, i|
      item.private_copy(display.id) do |copied|
        copied.direction = 'asc'
        copied.layout   = i + 1
        copied.position = i + 1
      end
    end
    s = x.size
    y.sort_by(&:position).each_with_index do |item, i|
      item.private_copy(display.id) do |copied|
        copied.direction = 'asc'
        copied.layout    = 0
        copied.position  = s + i + 1
      end
    end
    display_narrowings.each {|dn| dn.private_copy(display.id)}
    return display
  end

end
