# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: default_matters
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  user_id      :integer       not null
#  matter_id    :integer       not null
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

# 利用者が指定する規定の案件のモデル。
class DefaultMatter < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  validates_presence_of :user_id, :matter_id

  belongs_to :domain
  belongs_to :user
  belongs_to :matter
end
