# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: default_lists
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  user_id      :integer       not null
#  product_id   :integer       not null
#  display_id   :integer       not null
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

# 利用者が指定する既定の一覧のモデル。
class DefaultList < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  validates_presence_of :user_id, :product_id, :display_id

  belongs_to :domain
  belongs_to :user
  belongs_to :product
  belongs_to :display
end
