# -*- coding: utf-8 -*-
class ConfigPicker < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor

  belongs_to :domain
  validates_associated :domain

  def self.model_class(controller_name, source_name)
    r = find(:first, :select => "model_name", :conditions => {:controller_name => controller_name, :source_name => source_name})
    raise ArgumentError, "model name not found: #{controller_name}:#{source_name}" unless r
    r.model_name.constantize
  end
end
