# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: config_passwords
#
#  id                :integer       not null, primary key
#  domain_id         :integer       not null
#  min_length        :integer
#  enable_max_age    :boolean       not null
#  max_age           :integer
#  enable_min_age    :boolean       not null
#  min_age           :integer
#  enforce_change    :boolean
#  enable_lockout    :boolean       not null
#  lockout_threshold :integer
#  created_at        :string(14)
#  updated_at        :string(14)
#  created_by        :integer
#  updated_by        :integer
#  created_in        :integer
#  updated_in        :integer
#  lock_version      :integer       default(0), not null
#

# パスワードの設定のモデル。
class ConfigPassword < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor

  belongs_to :domain
  validates_associated :domain

  # ドメインに応じた設定を返す。
  def self.current
    return find_by_domain_id(User.current.domain_id)
  end
end
