class Circular < ActiveRecord::Base
  set_table_name "circulars"

  timestamps_as_string
  user_monitor
  
  has_many :details, :class_name =>"CircularApprover", :foreign_key => "circular_id", :dependent => :destroy
  has_many :users
  attr_accessor :pertinents
  
  acts_as_permissible

  after_create :per_circular_number
  after_create :per_circular_approver
  
#start free line

   def per_circular_number
     per_current_number = Counter.find(:first,:conditions=>{:domain_id=>self.domain_id, :table_name=> "circulars"})
     per_current_number.current_number += 1
     per_current_number.save!
   end
   
   def per_circular_approver
   end
   
     def per_person_of_creation
    person_of_creation = Circular.find(:all, :conditions=>{:person_of_creation=>CacheEachRequest.current[:user].person_id, :domain_id=>CacheEachRequest.current[:user].domain_id}).map(&:id)
    return person_of_creation
  end
  
  def per_person_of_circulation
    person_of_circulation = Circular.find(:all, :conditions=>{:person_of_circulation=>CacheEachRequest.current[:user].person_id, :domain_id=>CacheEachRequest.current[:user].domain_id}).map(&:id)
    return person_of_circulation
  end
  
  def per_person_of_creation_or_circulation
    person_of_creation = per_person_of_creation
    person_of_circulation = per_person_of_circulation
    if person_of_creation == [] && person_of_circulation != []
      person_of_creation_or_circulation = person_of_circulation
    elsif person_of_circulation == [] && person_of_creation != []
      person_of_creation_or_circulation = person_of_creation
    elsif person_of_creation != [] && person_of_circulation != []
      person_of_creation_or_circulation = person_of_creation | person_of_circulation
    elsif person_of_creation == [] && person_of_circulation == []
      person_of_creation_or_circulation = [0]
    end
    return person_of_creation_or_circulation
  end
  
  def per_person_of_creation_or_circulation_readable
    person_of_creation_or_circulation = per_person_of_creation_or_circulation
    person_of_creation_or_circulation_readable = Circular.find_by_sql("select * from circulars where domain_id = #{User.current.domain_id} and id in (#{person_of_creation_or_circulation.join(",")}) and (status = 0 or (end_show_day >= #{Time.now.strftime("%Y%m%d")} or end_show_day is null or end_show_day = ''))").map(&:id)
    person_of_creation_or_circulation_readable = [0] if person_of_creation_or_circulation_readable == []
    return person_of_creation_or_circulation_readable
  end
  
  def per_person_of_approver
    approver = CircularApprover.find(:all, :conditions=>{:person_id=> CacheEachRequest.current[:user].person_id, :domain_id=>CacheEachRequest.current[:user].domain_id}).map(&:circular_id)
    approver = [0] if approver == []
    person_of_approver = Circular.find_by_sql("select * from circulars where domain_id = #{User.current.domain_id} and id in (#{approver.join(",")})").map(&:id)
    person_of_approver = [0] if person_of_approver == []
    return person_of_approver
  end
  
  def per_person_of_approver_readable
    person_of_approver = per_person_of_approver
    person_of_approver_readable = Circular.find_by_sql("select * from circulars where domain_id = #{User.current.domain_id} and id in (#{person_of_approver.join(",")}) and status != 0 and (end_show_day >= #{Time.now.strftime("%Y%m%d")} or end_show_day is null or end_show_day = '') ").map(&:id)
    person_of_approver_readable = [0] if person_of_approver_readable == []
    return person_of_approver_readable
  end
  
  def per_end_user_of_confirmation
    end_user_of_confirmation = Circular.find(:all, :conditions=>{:end_user_of_confirmation=> CacheEachRequest.current[:user].person_id, :domain_id=>CacheEachRequest.current[:user].domain_id}).map(&:id)
    end_user_of_confirmation = [0] if end_user_of_confirmation == []
    return end_user_of_confirmation
  end
  
  def per_end_user_of_confirmation_readable
    end_user_of_confirmation = per_end_user_of_confirmation
    end_user_of_confirmation_readable = Circular.find_by_sql("select * from circulars where domain_id = #{User.current.domain_id} and id in (#{end_user_of_confirmation.join(",")}) and (status != 0 and ((end_show_day >= #{Time.now.strftime("%Y%m%d")} or end_show_day is null or end_show_day = '') or confirmation_day is null or confirmation_day = ''))").map(&:id)
    end_user_of_confirmation_readable = [0] if end_user_of_confirmation_readable == []
    return end_user_of_confirmation_readable
  end
  
  def per_relation_all_readable
    person_of_creation_or_circulation_readable = per_person_of_creation_or_circulation_readable
    person_of_approver_readable = per_person_of_approver_readable
    end_user_of_confirmation_readable = per_end_user_of_confirmation_readable
    if person_of_creation_or_circulation_readable == [0] && person_of_approver_readable != [0] && end_user_of_confirmation_readable != [0]
      relation_all_readable = person_of_approver_readable | end_user_of_confirmation_readable
    elsif person_of_approver_readable == [0] && person_of_creation_or_circulation_readable != [0] && end_user_of_confirmation_readable != [0]
      relation_all_readable = person_of_creation_or_circulation_readable | end_user_of_confirmation_readable
    elsif end_user_of_confirmation_readable == [0] && person_of_creation_or_circulation_readable != [0] && person_of_approver_readable != [0]
      relation_all_readable = person_of_creation_or_circulation_readable | person_of_approver_readable
    elsif person_of_creation_or_circulation_readable != [0] && person_of_approver_readable == [0] && end_user_of_confirmation_readable == [0]  
      relation_all_readable = person_of_creation_or_circulation_readable
    elsif person_of_creation_or_circulation_readable == [0] && person_of_approver_readable != [0] && end_user_of_confirmation_readable == [0]  
      relation_all_readable = person_of_approver_readable
    elsif person_of_creation_or_circulation_readable == [0] && person_of_approver_readable == [0] && end_user_of_confirmation_readable != [0]  
      relation_all_readable = end_user_of_confirmation_readable
    elsif end_user_of_confirmation_readable != [0] && person_of_creation_or_circulation_readable != [0] && person_of_approver_readable != [0]
      relation_all_readable = person_of_creation_or_circulation_readable | person_of_approver_readable | end_user_of_confirmation_readable
    else
      relation_all_readable = [0]
    end
    return relation_all_readable
  end
  
  def per_circular_all_readable
    circular_all_readable = Circular.find_by_sql("select * from circulars where domain_id = #{User.current.domain_id} and status != 0 and (end_show_day >= #{Time.now.strftime("%Y%m%d")} or end_show_day is null or end_show_day = '') ").map(&:id)
    circular_all_readable = [0] if circular_all_readable == []
    return circular_all_readable
  end
  
  def per_person_all_readable
    relation_all_readable = per_relation_all_readable
    circular_all_readable = per_circular_all_readable
    if relation_all_readable == [0] && circular_all_readable != [0]
      person_all_readable = circular_all_readable      
    elsif circular_all_readable == [0] && relation_all_readable != [0]
      person_all_readable = relation_all_readable
    elsif relation_all_readable == [0] && circular_all_readable == [0]
      person_all_readable = [0]
    elsif relation_all_readable != [0] && circular_all_readable != [0]
      person_all_readable = relation_all_readable | circular_all_readable      
    end
    return person_all_readable
  end

   def for_selected_circular_position(selected_circular_position)
    person_of_creation_or_circulation = per_person_of_creation_or_circulation
    person_of_creation_or_circulation_readable = per_person_of_creation_or_circulation_readable
    person_of_approver = per_person_of_approver
    person_of_approver_readable = per_person_of_approver_readable
    end_user_of_confirmation = per_end_user_of_confirmation
    end_user_of_confirmation_readable = per_end_user_of_confirmation_readable
    if selected_circular_position == s_("PjcCircular|created circular・circular circular")
      position = " circulars.id in (#{person_of_creation_or_circulation.join(",")}) "
      position_add = " circulars.id in (#{person_of_creation_or_circulation_readable.join(",")}) "
    elsif selected_circular_position == s_("PjcCircular|approve circular")
      position = " circulars.id in (#{person_of_approver.join(",")}) and status = 1 "
      position_add = " circulars.id in (#{person_of_approver_readable.join(",")}) and status = 1 "
    elsif selected_circular_position == s_("PjcCircular|confirm circular")
      position = " circulars.id in (#{end_user_of_confirmation.join(",")} ) and status = 2 "
      position_add = " circulars.id in (#{end_user_of_confirmation_readable.join(",")}) and status = 2 "
    else
      position = ""
      position_add = ""
    end
    return position,position_add
   end

   def per_division
     person_all_readable = Circular.new.per_person_all_readable
     relation_all_readable = Circular.new.per_relation_all_readable
     division = " ((circulation_open_division = 2 and circulars.id in (#{person_all_readable.join(",")})) or (circulation_open_division = 1 and circulars.id in (#{relation_all_readable.join(",")}))) "
     return division
   end

   def cmn_note
     details.each do |d|
       return d.notes
     end
   end

#end free line
end
