# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: auto_documents
#
#  id                   :integer       not null, primary key
#  domain_id            :integer       not null
#  relatable_product_id :integer
#  target_product_id    :integer
#  target_id_method     :string(255)
#  created_at           :string(14)
#  updated_at           :string(14)
#  created_by           :integer
#  updated_by           :integer
#  created_in           :integer
#  updated_in           :integer
#  lock_version         :integer       default(0), not null
#


# 関連文書の自動登録のモデル
class AutoDocument < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor

  belongs_to :domain
  belongs_to :relatable_product, :class_name => "Product", :foreign_key => "relatable_product_id"
  belongs_to :target_product, :class_name => "Product", :foreign_key => "target_product_id"

end
