# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: attachments
#
#  id              :integer       not null, primary key
#  domain_id       :integer       not null
#  attachable_type :string(255)   not null
#  attachable_id   :integer       not null
#  file_type       :string(255)   not null
#  file_id         :integer       not null
#  description     :string(255)
#  created_at      :string(14)
#  updated_at      :string(14)
#  created_by      :integer
#  updated_by      :integer
#  created_in      :integer
#  updated_in      :integer
#  lock_version    :integer       default(0), not null
#

# 添付ファイルのモデル
class Attachment < ActiveRecord::Base
  LABEL_FILE_TYPE = [
    [N_("rfw|Attachment|file_type|Database"), "BinaryObject"],
    [N_("rfw|Attachment|file_type|Server"), "StorageObject"],
  ]

  untranslate_all
  timestamps_as_string
  user_monitor

  belongs_to :attachable, :polymorphic => true
  belongs_to :file, :polymorphic => true

  after_destroy 'self.file.destroy'

  delegate :name, :to => :file
  delegate :length, :to => :file
  delegate :location, :to => :file

  # 複写機能のためのコピーを返す。失敗した場合は <tt>false</tt> を返す。
  def copy
    copied = self.class.new
    copied.attributes = attributes
    if copied.file = file.copy
      copied.attachable_id = nil
      return copied
    end
    return false
  end
end
