# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: application_models
#
#  id                   :integer       not null, primary key
#  domain_id            :integer       not null
#  application_table_id :integer       not null
#  name                 :string(255)   not null
#  parent_method_name   :string(255)
#  created_at           :string(14)
#  updated_at           :string(14)
#  created_by           :integer
#  updated_by           :integer
#  created_in           :integer
#  updated_in           :integer
#  lock_version         :integer       default(0), not null
#

class ApplicationModel < ActiveRecord::Base
  include CUI

  untranslate_all

  has_many :has_manies, :dependent => :destroy#追加
  belongs_to :domain
  belongs_to :application_table

  #after_destroy :drop_model

  def table_name
    application_table.name
  end
  
  def create_model
    has_many_as_name_aru = ""
    has_many_as_name_nai = ""
    HasMany.find(:all, :conditions => {:application_model_id => id},:order => "id").each do |has_many|
      if has_many == nil
       has_many = HasMany.new
      end
      if has_many.as_name
        has_many_as_name_aru += "has_many :#{has_many.name}, :as => \"#{has_many.as_name}\"\n\s\s"
      else
        has_many_as_name_nai += "has_many :#{has_many.name}, :class_name =>\"#{has_many.class_name}\", :foreign_key => \"#{has_many.foreign_key}\", :dependent => :#{has_many.dependent}\n\s\s"
      end
    end
    belongs_to_polymorphic_true = ""
    belongs_to_polymorphic_false = ""
    BelongsTo.find(:all, :conditions => {:application_table_id => application_table.id, :application_model_id => id}, :order => "id").each do |belongs_to|
      if belongs_to == nil
      belongs_to = BelongsTo.new
      end
      if belongs_to.polymorphic == true
        belongs_to_polymorphic_true += "belongs_to :#{belongs_to.name}, :polymorphic => true\n\s\s"
      end
      if belongs_to.polymorphic == false
        belongs_to_polymorphic_false += "belongs_to :#{belongs_to.name}, :class_name => \"#{belongs_to.class_name}\", :foreign_key => \"#{belongs_to.forein_key}\"\n\s\s"
      end
    end
    ary = Array.new
    ApplicationModel.find(:all, :conditions => {:application_table_id => application_table.id,:id => id}, :order => "id").each do |model_name|
        file_name = model_name.name.underscore.downcase
      if File.exist?("app/models/#{file_name}.rb")
        file = File.open("app/models/#{file_name}.rb")
        ary = file.to_a
        ary = ary[(ary.index("#start free line\n")+ 1)..(ary.index("#end free line\n") - 1) ]
        file.close
      end
    name = file_name

    script_destroy = Pathname.new(RAILS_ROOT) + "script/destroy"
    rest = pretend? ? ['--pretend'] : []
    system(ruby, script_destroy.to_s, "application_model", name, *rest)
    
    script_generate = Pathname.new(RAILS_ROOT) + "script/generate"
    rest = ["table_name~#{table_name}", "belongs_to_polymorphic_true~#{belongs_to_polymorphic_true}", "belongs_to_polymorphic_false~#{belongs_to_polymorphic_false}", "has_many_as_name_aru~#{has_many_as_name_aru}", "has_many_as_name_nai~#{has_many_as_name_nai}", "parent_method_name~#{parent_method_name}", "ary~#{ary}"]
    #rest = ["table_name:table_name", "parent_method_name:parent_method_name", "b_name:b_name", "b_class_name:b_class_name", "b_forein_key:b_forein_key", "b_polymorphic:b_polymorphic", "h_name:h_name", "h_class_name:h_class_name", "h_forein_key:h_forein_key", "h_dependent:h_dependent", "h_as_name:h_as_name"]
    rest |= ['--pretend'] if pretend?
    system(ruby, script_generate.to_s, "application_model", name, *rest)
    end
  end

  def drop_model
    script_destroy = Pathname.new(RAILS_ROOT) + "script/destroy"
    rest = pretend? ? ['--pretend'] : []
    system(ruby, script_destroy.to_s, "application_model", name, *rest)
  end
end
